/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.zonesui;

import java.awt.Polygon;
import java.awt.Shape;
import org.lsst.ccs.utilities.zonesui.ShapeBean;

public class ZPolygon
implements ShapeBean {
    private String[] pointCoords;

    public ZPolygon() {
    }

    public ZPolygon(String ... str) {
        this.pointCoords = str;
    }

    public String[] getPoints() {
        return this.pointCoords;
    }

    public void setPoints(String ... st) {
        this.pointCoords = st;
    }

    public int getNbPoint() {
        return this.pointCoords.length + 1;
    }

    public int[][] getXY() {
        int[][] tabXY = new int[this.getNbPoint()][2];
        for (int i = 0; i < this.getNbPoint() - 1; ++i) {
            String[] coords = this.pointCoords[i].split(",");
            tabXY[i][0] = Integer.parseInt(coords[0]);
            tabXY[i][1] = Integer.parseInt(coords[1]);
        }
        tabXY[this.getNbPoint() - 1][0] = tabXY[0][0];
        tabXY[this.getNbPoint() - 1][1] = tabXY[0][1];
        return tabXY;
    }

    public int[] getX(int[][] tab) {
        int[] tabX = new int[tab.length];
        for (int i = 0; i < tab.length; ++i) {
            tabX[i] = tab[i][0];
        }
        return tabX;
    }

    public int[] getY(int[][] tab) {
        int[] tabY = new int[tab.length];
        for (int i = 0; i < tab.length; ++i) {
            tabY[i] = tab[i][1];
        }
        return tabY;
    }

    @Override
    public Shape genShape() {
        return new Polygon(this.getX(this.getXY()), this.getY(this.getXY()), this.getNbPoint());
    }

    public String toString() {
        int[] ix = this.getX(this.getXY());
        int[] iy = this.getY(this.getXY());
        String str = "APolygon with " + this.getNbPoint() + " points:";
        for (int i = 0; i < this.getNbPoint(); ++i) {
            str = str + " (" + ix[i] + "," + iy[i] + ")";
        }
        return str;
    }
}

