/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.lsst.ccs.gconsole.base.Const;

public final class DateTimePicker
extends JDialog {
    private LocalDate date;
    private LocalTime time;
    private boolean armed;
    private JComboBox<String> monthCombo;
    JSpinner yearSpinner;
    private CalendarModel calModel;
    private JTable calTable;

    private DateTimePicker(LocalDate seedDate, LocalTime seedTime, String title, Component parent) {
        super(parent == null ? null : SwingUtilities.getWindowAncestor(parent), title, Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.date = seedDate;
        this.time = seedTime;
        Box root = Box.createVerticalBox();
        this.add(root);
        root.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        if (this.time != null) {
            JPanel datePanel = new JPanel();
            root.add(datePanel);
            datePanel.setLayout(new BorderLayout());
            datePanel.setBorder(BorderFactory.createTitledBorder("Date"));
            Box monthYearPanel = Box.createHorizontalBox();
            datePanel.add((Component)monthYearPanel, "North");
            JButton prevButton = new JButton("<");
            monthYearPanel.add(prevButton);
            prevButton.addActionListener(e -> {
                this.date = this.date.minusMonths(1L);
                this.resetFromDate();
            });
            monthYearPanel.add(Box.createRigidArea(Const.HDIM));
            this.monthCombo = new JComboBox<Object>(Arrays.stream(Month.values()).map(m -> m.getDisplayName(TextStyle.FULL, Locale.US)).collect(Collectors.toList()).toArray());
            monthYearPanel.add(this.monthCombo);
            this.monthCombo.setEditable(false);
            this.monthCombo.addActionListener(e -> {
                if (this.armed) {
                    this.date = this.date.withMonth(this.monthCombo.getSelectedIndex() + 1);
                    this.calModel.update();
                }
            });
            monthYearPanel.add(Box.createRigidArea(Const.HDIM));
            this.yearSpinner = new JSpinner(new SpinnerNumberModel(this.date.getYear(), 0, 9999, 1));
            monthYearPanel.add(this.yearSpinner);
            this.yearSpinner.setEditor(new JSpinner.NumberEditor(this.yearSpinner, "####"));
            this.yearSpinner.addChangeListener(e -> {
                if (this.armed) {
                    this.date = this.date.withYear((Integer)this.yearSpinner.getValue());
                    this.calModel.update();
                }
            });
            monthYearPanel.add(Box.createRigidArea(Const.HDIM));
            JButton nextButton = new JButton(">");
            monthYearPanel.add(nextButton);
            nextButton.addActionListener(e -> {
                this.date = this.date.plusMonths(1L);
                this.resetFromDate();
            });
            JPanel calPanel = new JPanel();
            datePanel.add((Component)calPanel, "Center");
            calPanel.setLayout(new BorderLayout());
            calPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), BorderFactory.createLineBorder(Color.GRAY)));
            this.calModel = new CalendarModel();
            this.calTable = new JTable(this.calModel);
            JTableHeader head = this.calTable.getTableHeader();
            calPanel.add((Component)head, "North");
            calPanel.add((Component)this.calTable, "Center");
            this.calTable.setDefaultRenderer(Integer.class, new CalendarCellRenderer());
            this.calTable.setSelectionMode(0);
            this.calTable.setCellSelectionEnabled(true);
            Enumeration<TableColumn> en = this.calTable.getColumnModel().getColumns();
            while (en.hasMoreElements()) {
                en.nextElement().setPreferredWidth(this.calTable.getRowHeight() * 2);
            }
            this.calTable.setRowHeight(Math.round((float)this.calTable.getRowHeight() * 1.1f));
            this.calTable.setShowGrid(false);
            head.setReorderingAllowed(false);
            head.setResizingAllowed(false);
            head.setDefaultRenderer(new DefaultTableCellRenderer(){

                @Override
                public boolean isOpaque() {
                    return true;
                }

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    this.setHorizontalAlignment(0);
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            });
            head.setBorder(new MatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
            this.calTable.getSelectionModel().addListSelectionListener(e -> {
                if (this.armed && !e.getValueIsAdjusting()) {
                    this.onCalSelect();
                }
            });
            this.calTable.getColumnModel().getSelectionModel().addListSelectionListener(e -> {
                if (this.armed && !e.getValueIsAdjusting()) {
                    this.onCalSelect();
                }
            });
            this.resetFromDate();
        }
        if (this.time != null) {
            JPanel timePanel = new JPanel();
            root.add(timePanel);
            timePanel.setLayout(new GridLayout(1, 3, 10, 5));
            timePanel.setBorder(BorderFactory.createTitledBorder("Time"));
            Box box = Box.createHorizontalBox();
            timePanel.add(box);
            box.setBorder(BorderFactory.createTitledBorder("Hours"));
            Spinner hSpinner = new Spinner(new CycleSpinnerModel((Number)this.time.getHour(), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(23), (Number)1));
            box.add(hSpinner);
            hSpinner.addChangeListener(e -> {
                this.time = this.time.withHour((Integer)hSpinner.getValue());
            });
            box = Box.createHorizontalBox();
            timePanel.add(box);
            box.setBorder(BorderFactory.createTitledBorder("Minutes"));
            Spinner mSpinner = new Spinner(new CycleSpinnerModel((Number)this.time.getMinute(), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(59), (Number)1));
            box.add(mSpinner);
            mSpinner.addChangeListener(e -> {
                this.time = this.time.withMinute((Integer)mSpinner.getValue());
            });
            box = Box.createHorizontalBox();
            timePanel.add(box);
            box.setBorder(BorderFactory.createTitledBorder("Seconds"));
            Spinner sSpinner = new Spinner(new CycleSpinnerModel((Number)this.time.getSecond(), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(59), (Number)1));
            box.add(sSpinner);
            sSpinner.addChangeListener(e -> {
                this.time = this.time.withSecond((Integer)sSpinner.getValue());
            });
        }
        Box buttonsPanel = Box.createHorizontalBox();
        root.add(buttonsPanel);
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        buttonsPanel.add(Box.createHorizontalGlue());
        JButton button = new JButton("Cancel");
        buttonsPanel.add(button);
        button.addActionListener(e -> {
            this.date = null;
            this.time = null;
            this.dispose();
        });
        buttonsPanel.add(Box.createHorizontalGlue());
        button = new JButton("  OK  ");
        buttonsPanel.add(button);
        button.addActionListener(e -> this.dispose());
        buttonsPanel.add(Box.createHorizontalGlue());
    }

    public static LocalDateTime selectDateTime(LocalDateTime seed, String title, Component parent) {
        if (seed == null) {
            seed = LocalDateTime.now().withMinute(0).withSecond(0).withNano(0);
        }
        if (title == null) {
            title = "Select date and time";
        }
        DateTimePicker dialog = new DateTimePicker(seed.toLocalDate(), seed.toLocalTime(), title, parent);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (dialog.date == null || dialog.time == null) {
            return null;
        }
        return LocalDateTime.of(dialog.date, dialog.time);
    }

    public static LocalDate selectDate(LocalDate seed, String title, Component parent) {
        if (seed == null) {
            seed = LocalDate.now();
        }
        if (title == null) {
            title = "Select date";
        }
        DateTimePicker dialog = new DateTimePicker(seed, null, title, parent);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.date;
    }

    public static LocalTime selectTime(LocalTime seed, String title, Component parent) {
        if (seed == null) {
            seed = LocalTime.now().withMinute(0).withSecond(0).withNano(0);
        }
        if (title == null) {
            title = "Select time";
        }
        DateTimePicker dialog = new DateTimePicker(null, seed, title, parent);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.time;
    }

    private void onCalSelect() {
        int row = this.calTable.getSelectedRow();
        int column = this.calTable.getSelectedColumn();
        if (row == -1 || column == -1) {
            this.resetFromDate();
        } else {
            int day = this.calModel.getValueAt(row, column);
            if (Math.abs(day) > 100) {
                day /= 100;
            }
            if (day > 0) {
                this.date = this.date.withDayOfMonth(day);
            } else {
                day = -day;
                this.date = this.date.withDayOfMonth(day);
                this.date = day < 15 ? this.date.plusMonths(1L) : this.date.minusMonths(1L);
                this.resetFromDate();
            }
        }
    }

    private void resetFromDate() {
        this.armed = false;
        this.monthCombo.setSelectedIndex(this.date.getMonthValue() - 1);
        this.yearSpinner.setValue(this.date.getYear());
        this.calModel.update();
        this.armed = true;
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            LocalDateTime time = LocalDateTime.now();
            while (time != null) {
                time = DateTimePicker.selectDateTime(time, null, null);
                System.out.println(time);
            }
        });
    }

    private static final class CycleSpinnerModel
    extends SpinnerNumberModel {
        CycleSpinnerModel(Number value, Comparable minimum, Comparable maximum, Number stepSize) {
            super(value, minimum, maximum, stepSize);
        }

        @Override
        public Object getPreviousValue() {
            Comparable<?> out = super.getPreviousValue();
            return out == null ? this.getMaximum() : out;
        }

        @Override
        public Object getNextValue() {
            Comparable<?> out = super.getNextValue();
            return out == null ? this.getMinimum() : out;
        }
    }

    private static final class Spinner
    extends JSpinner {
        Spinner(SpinnerNumberModel model) {
            super(model);
            JSpinner.NumberEditor editor = new JSpinner.NumberEditor((JSpinner)this, "00");
            JFormattedTextField field = editor.getTextField();
            FontMetrics fm = field.getFontMetrics(field.getFont());
            int pad = fm.charWidth('0') / 2;
            editor.getTextField().setBorder(BorderFactory.createEmptyBorder(0, pad, 0, pad));
            this.setEditor(editor);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
        }
    }

    private static final class CalendarCellRenderer
    extends DefaultTableCellRenderer {
        CalendarCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int v = (Integer)value;
            boolean thisMonth = v > 0;
            boolean today = false;
            if (Math.abs(v) >= 100) {
                today = true;
                v /= 100;
            }
            if (!thisMonth) {
                v = -v;
            }
            super.getTableCellRendererComponent(table, v, isSelected, hasFocus, row, column);
            this.setEnabled(thisMonth);
            if (today) {
                this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }

    private class CalendarModel
    extends AbstractTableModel {
        private int prevLast;
        private int last;
        private int v00;
        private int today;

        private CalendarModel() {
        }

        @Override
        public int getRowCount() {
            return 6;
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public Integer getValueAt(int row, int column) {
            int date;
            int i = row * 7 + column;
            int out = i <= this.prevLast ? -(this.v00 + i) : (i > this.last ? this.last - i : (date = i - this.prevLast));
            if (i == this.today) {
                out *= 100;
            }
            return out;
        }

        @Override
        public String getColumnName(int column) {
            return DayOfWeek.of(column + 1).getDisplayName(TextStyle.NARROW, Locale.US);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Integer.class;
        }

        void update() {
            int dayOfWeek = DateTimePicker.this.date.withDayOfMonth(1).getDayOfWeek().getValue();
            this.prevLast = dayOfWeek == 1 ? 6 : dayOfWeek - 2;
            this.v00 = DateTimePicker.this.date.withDayOfMonth(1).minusDays(1L).getDayOfMonth() - this.prevLast;
            this.last = this.prevLast + DateTimePicker.this.date.getMonth().length(DateTimePicker.this.date.isLeapYear());
            LocalDate dNow = LocalDate.now();
            LocalDate d00 = DateTimePicker.this.date.minusMonths(1L).withDayOfMonth(this.v00);
            long todayIndex = ChronoUnit.DAYS.between(d00, dNow);
            this.today = todayIndex > -1L && todayIndex < 42L ? (int)todayIndex : -1;
            this.fireTableDataChanged();
            int selected = DateTimePicker.this.date.getDayOfMonth() + this.prevLast;
            int row = selected / 7;
            int column = selected % 7;
            DateTimePicker.this.calTable.getSelectionModel().setValueIsAdjusting(true);
            DateTimePicker.this.calTable.getColumnModel().getSelectionModel().setValueIsAdjusting(true);
            DateTimePicker.this.calTable.getSelectionModel().setSelectionInterval(row, row);
            DateTimePicker.this.calTable.getColumnModel().getSelectionModel().setSelectionInterval(column, column);
            DateTimePicker.this.calTable.getSelectionModel().setValueIsAdjusting(true);
            DateTimePicker.this.calTable.getColumnModel().getSelectionModel().setValueIsAdjusting(true);
        }
    }
}

