/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.ChannelSelector;
import org.lsst.ccs.gconsole.util.MatchPredicate;

final class PathPattern
implements ChannelSelector {
    static final Pattern pAgent = Pattern.compile("([\\w\\-]+)/.*");
    private String agent;
    private Predicate<String> pattern;

    PathPattern() {
    }

    static PathPattern compile(String rawTemplate) {
        PathPattern out = new PathPattern();
        if (rawTemplate.startsWith("/")) {
            rawTemplate = "[^/]+" + rawTemplate;
        } else {
            Matcher m = pAgent.matcher(rawTemplate);
            if (m.matches()) {
                out.agent = m.group(1);
            }
        }
        if (rawTemplate.endsWith("/")) {
            rawTemplate = rawTemplate + ".+";
        }
        try {
            out.pattern = new MatchPredicate(rawTemplate);
            return out;
        }
        catch (PatternSyntaxException x) {
            return null;
        }
    }

    @Override
    public String getAgent() {
        return this.agent;
    }

    @Override
    public boolean match(AgentChannel channel) {
        return this.pattern.test(channel.getPath());
    }
}

