/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.gconsole.plugins.tracer.FilterStep;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;

public class MultistepFilter
implements MessageFilter {
    final FilterStep[] steps;
    final boolean[] ors;

    public MultistepFilter(FilterStep[] filters, boolean[] or) {
        this.steps = filters;
        this.ors = or;
    }

    public MultistepFilter(Descriptor descriptor) {
        this.ors = descriptor.getOrs();
        int n = descriptor.getSteps().length;
        this.steps = new FilterStep[n];
        for (int i = 0; i < n; ++i) {
            this.steps[i] = new FilterStep(descriptor.getSteps()[i]);
        }
    }

    @Override
    public FilteredMessage apply(FilteredMessage filteredMessage) {
        boolean failedOR = false;
        boolean goodOR = false;
        for (int i = 0; i < this.steps.length; ++i) {
            FilterStep filter = this.steps[i];
            if (this.ors[i]) {
                if (goodOR) continue;
                FilteredMessage fm = filter.apply(filteredMessage);
                if (fm == null) {
                    failedOR = true;
                    continue;
                }
                failedOR = false;
                goodOR = true;
                filteredMessage = fm;
                continue;
            }
            if (failedOR) {
                return null;
            }
            if ((filteredMessage = filter.apply(filteredMessage)) == null) {
                return null;
            }
            goodOR = false;
        }
        return failedOR ? null : filteredMessage;
    }

    public Descriptor save() {
        Descriptor desc = new Descriptor();
        int n = this.steps.length;
        Descriptor.access$002(desc, new FilterStep.Descriptor[n]);
        for (int i = 0; i < n; ++i) {
            ((Descriptor)desc).steps[i] = this.steps[i].save();
        }
        Descriptor.access$102(desc, Arrays.copyOf(this.ors, this.ors.length));
        return desc;
    }

    public static class Descriptor
    implements Serializable,
    Cloneable {
        private FilterStep.Descriptor[] steps;
        private boolean[] ors;

        public boolean[] getOrs() {
            return this.ors;
        }

        public void setOrs(boolean[] ors) {
            this.ors = ors;
        }

        public FilterStep.Descriptor[] getSteps() {
            return this.steps;
        }

        public void setSteps(FilterStep.Descriptor[] steps) {
            this.steps = steps;
        }

        protected Descriptor clone() {
            try {
                Descriptor desc = (Descriptor)super.clone();
                if (this.steps != null) {
                    int n = this.steps.length;
                    desc.steps = new FilterStep.Descriptor[n];
                    for (int i = 0; i < n; ++i) {
                        desc.steps[i] = this.steps[i].clone();
                    }
                }
                if (this.ors != null) {
                    desc.ors = Arrays.copyOf(this.ors, this.ors.length);
                }
                return desc;
            }
            catch (CloneNotSupportedException x) {
                return null;
            }
        }

        static /* synthetic */ FilterStep.Descriptor[] access$002(Descriptor x0, FilterStep.Descriptor[] x1) {
            x0.steps = x1;
            return x1;
        }

        static /* synthetic */ boolean[] access$102(Descriptor x0, boolean[] x1) {
            x0.ors = x1;
            return x1;
        }
    }
}

