/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.lsst.ccs.rest.file.server.client.RestFileSystemOptions;

class RestFileSystemOptionsHelper {
    private final Map<String, ?> env;

    RestFileSystemOptionsHelper(Map<String, ?> env) {
        this.env = env;
    }

    RestFileSystemOptions.CacheOptions getCacheOptions() {
        return this.getOption("CacheOptions", RestFileSystemOptions.CacheOptions.class, RestFileSystemOptions.CacheOptions.NONE);
    }

    RestFileSystemOptions.SSLOptions isUseSSL() {
        return this.getOption("UseSSL", RestFileSystemOptions.SSLOptions.class, RestFileSystemOptions.SSLOptions.AUTO);
    }

    RestFileSystemOptions.CacheFallback getCacheFallback() {
        return this.getOption("CacheFallback", RestFileSystemOptions.CacheFallback.class, RestFileSystemOptions.CacheFallback.OFFLINE);
    }

    boolean isCacheLogging() {
        return this.getOption("CacheLogging", Boolean.class, Boolean.FALSE);
    }

    boolean allowAlternateCacheLoction() {
        return this.getOption("CacheFallbackLocation", Boolean.class, Boolean.FALSE);
    }

    Path getDiskCacheLocation() {
        Object result = this.env.get("CacheLocation");
        if (result == null) {
            return null;
        }
        if (result instanceof Path) {
            return (Path)result;
        }
        if (result instanceof File) {
            return ((File)result).toPath();
        }
        if (result instanceof String) {
            return Paths.get((String)result, new String[0]);
        }
        throw new IllegalArgumentException("Invalid value for option CacheLocation: " + result);
    }

    private <T> T getOption(String optionName, Class<T> type, T defaultValue) {
        Object result = this.env.get(optionName);
        if (result == null) {
            result = defaultValue;
        }
        if (type.isInstance(result)) {
            return type.cast(result);
        }
        throw new IllegalArgumentException("Invalid value for option " + optionName + ": " + result);
    }
}

