/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server.data;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestFileInfo
implements Serializable {
    private long lastModified;
    private long creationTime;
    private long lastAccessTime;
    private long size;
    private String mimeType;
    private String name;
    private String fileKey;
    private boolean isDirectory;
    private boolean isOther;
    private boolean isRegularFile;
    private boolean isSymbolicLink;
    private boolean isVersionedFile;
    private List<RestFileInfo> children;

    public RestFileInfo() {
    }

    public RestFileInfo(Path file, BasicFileAttributes fileAttributes, boolean isVersionedFile) throws IOException {
        this.name = file.getFileName().toString();
        this.size = fileAttributes.size();
        this.lastModified = fileAttributes.lastModifiedTime().toMillis();
        this.fileKey = fileAttributes.fileKey().toString();
        this.isDirectory = fileAttributes.isDirectory();
        this.isOther = fileAttributes.isOther();
        this.isRegularFile = fileAttributes.isRegularFile();
        this.isSymbolicLink = fileAttributes.isSymbolicLink();
        this.lastAccessTime = fileAttributes.lastAccessTime().toMillis();
        this.creationTime = fileAttributes.creationTime().toMillis();
        this.mimeType = Files.probeContentType(file);
        this.isVersionedFile = isVersionedFile;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public void setFileKey(String fileKey) {
        this.fileKey = fileKey;
    }

    public boolean isDirectory() {
        return this.isDirectory && !this.isVersionedFile;
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public boolean isOther() {
        return this.isOther || this.isVersionedFile;
    }

    public void setOther(boolean isOther) {
        this.isOther = isOther;
    }

    public boolean isRegularFile() {
        return this.isRegularFile;
    }

    public void setRegularFile(boolean isRegularFile) {
        this.isRegularFile = isRegularFile;
    }

    public boolean isSymbolicLink() {
        return this.isSymbolicLink;
    }

    public void setSymbolicLink(boolean isSymbolicLink) {
        this.isSymbolicLink = isSymbolicLink;
    }

    public boolean isVersionedFile() {
        return this.isVersionedFile;
    }

    public void setVersionedFile(boolean isVersionedFile) {
        this.isVersionedFile = isVersionedFile;
    }

    public List<RestFileInfo> getChildren() {
        return this.children;
    }

    public void setChildren(List<RestFileInfo> children) {
        this.children = children;
    }

    public String toString() {
        return "RestFileInfo{lastModified=" + this.lastModified + ", size=" + this.size + ", mimeType=" + this.mimeType + ", name=" + this.name + '}';
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("lastAccessTime", FileTime.fromMillis(this.lastAccessTime));
        result.put("lastModifiedTime", FileTime.fromMillis(this.lastModified));
        result.put("size", this.getSize());
        result.put("creationTime", FileTime.fromMillis(this.creationTime));
        result.put("isSymbolicLink", this.isSymbolicLink());
        result.put("isRegularFile", this.isRegularFile());
        result.put("fileKey", this.getFileKey());
        result.put("isOther", this.isOther());
        result.put("isDirectory", this.isDirectory());
        result.put("isVersionedFile", this.isVersionedFile());
        return result;
    }
}

