/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.ChannelPredicate;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.DevicePredicate;
import org.lsst.ccs.monitor.GroupPredicate;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorUpdateTask;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

class MonitorParallelTaskManager {
    static final String DEFAULT_TASK_NAME = "default";

    MonitorParallelTaskManager() {
    }

    static List<MonitorUpdateTask> getParallelTasks(Properties buildProperties, List<Channel> allChannels, Monitor monitor) {
        ArrayList<Channel> copyOfAllChannels = new ArrayList<Channel>(allChannels);
        List taskNames = (List)InputConversionEngine.convertArgToType((String)buildProperties.getProperty("org.lsst.ccs.subsystem.monitor.parallel.tasks", "[]"), List.class);
        if (taskNames.isEmpty() || !taskNames.contains(DEFAULT_TASK_NAME)) {
            taskNames.add(DEFAULT_TASK_NAME);
        }
        ArrayList<MonitorUpdateTask> parallelTasks = new ArrayList<MonitorUpdateTask>();
        for (String taskName : taskNames) {
            Map taskFilters = (Map)InputConversionEngine.convertArgToType((String)buildProperties.getProperty("org.lsst.ccs.subsystem.monitor.parallel." + taskName + ".filter", "[channels:.*]"), Map.class);
            ArrayList<Predicate<Channel>> filters = new ArrayList<Predicate<Channel>>();
            for (String filterType : taskFilters.keySet()) {
                filters.add(MonitorParallelTaskManager.getChannelFilter(filterType, (String)taskFilters.get(filterType)));
            }
            ArrayList<Channel> taskChannels = new ArrayList<Channel>();
            Iterator allChannelIterator = copyOfAllChannels.iterator();
            while (allChannelIterator.hasNext()) {
                Channel ch = (Channel)allChannelIterator.next();
                boolean selected = true;
                for (Predicate predicate : filters) {
                    if (predicate.test(ch)) continue;
                    selected = false;
                    break;
                }
                if (!selected) continue;
                allChannelIterator.remove();
                taskChannels.add(ch);
            }
            List taskSplits = (List)InputConversionEngine.convertArgToType((String)buildProperties.getProperty("org.lsst.ccs.subsystem.monitor.parallel." + taskName + ".split", "[]"), List.class);
            HashMap<String, ArrayList<Channel>> allNamedLists = new HashMap<String, ArrayList<Channel>>();
            allNamedLists.put(taskName, taskChannels);
            for (String string : taskSplits) {
                ChannelSplitter splitter = MonitorParallelTaskManager.getChannelSplitter(string);
                HashMap<String, List<Channel>> result = new HashMap<String, List<Channel>>();
                for (Map.Entry namedList : allNamedLists.entrySet()) {
                    result.putAll(splitter.split((String)namedList.getKey(), (List)namedList.getValue()));
                }
                allNamedLists.clear();
                allNamedLists.putAll(result);
            }
            for (Map.Entry entry : allNamedLists.entrySet()) {
                parallelTasks.add(new MonitorUpdateTask((String)entry.getKey(), (List)entry.getValue(), monitor));
            }
        }
        return parallelTasks;
    }

    private static Predicate<Channel> getChannelFilter(String name, String value) {
        switch (name.toLowerCase()) {
            case "channels": {
                return new ChannelPredicate(value);
            }
            case "groups": {
                return new GroupPredicate(value);
            }
            case "devices": {
                return new DevicePredicate(value);
            }
        }
        throw new IllegalArgumentException("Cannot create filter for " + name + ". Allowed values are: channels, groups, devices");
    }

    private static ChannelSplitter getChannelSplitter(String name) {
        switch (name) {
            case "byDevice": {
                return new ChannelSplitter(){

                    @Override
                    public Map<String, List<Channel>> split(String taskName, List<Channel> channels) {
                        HashMap<Device, List> deviceMap = new HashMap<Device, List>();
                        for (Channel ch : channels) {
                            List deviceChannelList = deviceMap.getOrDefault(ch.getDevice(), new ArrayList());
                            deviceChannelList.add(ch);
                            deviceMap.put(ch.getDevice(), deviceChannelList);
                        }
                        HashMap<String, List<Channel>> result = new HashMap<String, List<Channel>>();
                        for (Map.Entry e : deviceMap.entrySet()) {
                            if (e.getKey() == null) {
                                result.put(taskName, (List<Channel>)e.getValue());
                                continue;
                            }
                            result.put(taskName + "/" + ((Device)e.getKey()).getPath(), (List<Channel>)e.getValue());
                        }
                        return result;
                    }
                };
            }
            case "byGroup": {
                return new ChannelSplitter(){

                    @Override
                    public Map<String, List<Channel>> split(String taskName, List<Channel> channels) {
                        HashMap<String, List> groupMap = new HashMap<String, List>();
                        for (Channel ch : channels) {
                            List deviceChannelList = groupMap.getOrDefault(ch.getGroup(), new ArrayList());
                            deviceChannelList.add(ch);
                            groupMap.put(ch.getGroup(), deviceChannelList);
                        }
                        HashMap<String, List<Channel>> result = new HashMap<String, List<Channel>>();
                        for (Map.Entry e : groupMap.entrySet()) {
                            result.put(taskName + "/" + (String)e.getKey(), (List<Channel>)e.getValue());
                        }
                        return result;
                    }
                };
            }
        }
        throw new IllegalArgumentException("Cannot split on " + name);
    }

    static interface ChannelSplitter {
        public Map<String, List<Channel>> split(String var1, List<Channel> var2);
    }
}

