/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;
import org.lsst.ccs.config.remote.LocalToRemoteMigrationDAO;
import org.lsst.ccs.config.remote.RestFileServerRemoteDAO;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class ConvertLimitsCategoryToWarnings {
    public static void main(String[] args) throws Exception {
        String groovyName = null;
        String category = "Limits";
        String tag = "defaultInitial";
        switch (args.length) {
            case 1: {
                groovyName = args[0];
                break;
            }
            case 2: {
                groovyName = args[0];
                tag = args[1];
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal number of arguments. We expect up to two arguments:\nthe first argument must be the groovy file name\nthe second argument (optional) is the tag name (defaultInitial by default)");
            }
        }
        String cacheName = "LimitsCategoryMigration";
        String dao = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.config.remote", "false");
        Object configurationDao = dao.equalsIgnoreCase("true") ? new RestFileServerRemoteDAO(cacheName) : (dao.equalsIgnoreCase("migrate") ? new LocalToRemoteMigrationDAO(cacheName) : new LocalConfigurationDAO());
        SingleCategoryTag singleCatTag = new SingleCategoryTag(groovyName, tag, category);
        SingleCategoryTagData data = configurationDao.loadCategoryTag(singleCatTag);
        Properties conversionProps = new Properties();
        StringBuilder sb = new StringBuilder();
        for (String key : data.getConfigurationData().keySet()) {
            String comment;
            int keySplit = key.lastIndexOf("/");
            String component = key.substring(0, keySplit);
            String parameter = key.substring(keySplit + 1);
            if (conversionProps.containsKey(component)) {
                component = conversionProps.getProperty(component);
            }
            if ((comment = data.getCommentParameter(key)) != null) {
                sb.append(comment).append("\n");
            }
            String value = (String)data.getConfigurationData().get(key);
            if (parameter.equals("dbandHi")) {
                double dbandHi = (Double)InputConversionEngine.convertArgToType((String)value, Double.class);
                String limitHiPar = component + "/limitHi";
                String limitHiValue = (String)data.getConfigurationData().get(limitHiPar);
                if (limitHiValue == null) {
                    throw new RuntimeException("Could not find value for " + limitHiPar);
                }
                double limitHi = (Double)InputConversionEngine.convertArgToType((String)limitHiValue, Double.class);
                double warningHi = dbandHi <= 0.0 ? limitHi : limitHi - dbandHi;
                parameter = "warnHi";
                value = String.valueOf(warningHi);
            } else if (parameter.equals("dbandLo")) {
                double dbandLo = (Double)InputConversionEngine.convertArgToType((String)value, Double.class);
                String limitLoPar = component + "/limitLo";
                String limitLoValue = (String)data.getConfigurationData().get(limitLoPar);
                if (limitLoValue == null) {
                    throw new RuntimeException("Could not find value for " + limitLoPar);
                }
                double limitLo = (Double)InputConversionEngine.convertArgToType((String)limitLoValue, Double.class);
                double warningLo = dbandLo <= 0.0 ? limitLo : limitLo + dbandLo;
                parameter = "warnLo";
                value = String.valueOf(warningLo);
            }
            sb.append(component).append("/").append(parameter).append("=").append(value).append("\n");
        }
        SingleCategoryTagData convertedData = new SingleCategoryTagData(data.getSingleCategoryTag());
        convertedData.load((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        configurationDao.saveCategoryTagData(convertedData);
    }
}

