/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida.function;

import hep.aida.IFunction;
import hep.aida.ref.plotter.adapter.AIDAFunctionAdapter;
import jas.hist.Basic1DFunction;
import jas.hist.FunctionAdvancedOptions;
import jas.hist.FunctionFactoryError;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.util.JASDialog;
import jas.util.JASIcon;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.freehep.jas.extension.aida.function.AbstractFunctionFactory;

public class SumFunctionFactory
extends AbstractFunctionFactory {
    private Icon icon = JASIcon.create((Object)this, (String)"sum.gif");

    public SumFunctionFactory() {
        super("Sum of existing functions");
    }

    public Basic1DFunction createFunction(JASHist h) throws FunctionFactoryError {
        SumOfFunctions sum = new SumOfFunctions(h);
        this.chooseName(sum, h);
        int n = 0;
        Enumeration e = h.get1DFunctions();
        while (e.hasMoreElements()) {
            JASHistData data = (JASHistData)e.nextElement();
            Basic1DFunction func = (Basic1DFunction)data.getDataSource();
            sum.addFunction(func);
            ++n;
        }
        if (n < 2) {
            throw new FunctionFactoryError("Need at least two functions to sum!");
        }
        return sum;
    }

    @Override
    public Icon getFunctionIcon() {
        return this.icon;
    }

    private class SumOfFunctions
    extends AIDAFunctionAdapter
    implements Observer,
    FunctionAdvancedOptions {
        private hep.aida.ref.function.SumOfFunctions sum;
        private JASHist h;
        private int m_nParams;
        private int[] m_param;

        public SumOfFunctions(JASHist h) {
            super((IFunction)new hep.aida.ref.function.SumOfFunctions("sum", new ArrayList()));
            this.sum = (hep.aida.ref.function.SumOfFunctions)this.function();
            this.h = h;
        }

        void addFunction(Basic1DFunction f) {
            this.sum.addFunction(((AIDAFunctionAdapter)f).function());
            f.addObserver((Observer)this);
            this.mapParams();
        }

        boolean containsFunction(Basic1DFunction f) {
            return this.sum.containsFunction(((AIDAFunctionAdapter)f).function());
        }

        void removeFunction(Basic1DFunction f) {
            f.deleteObserver((Observer)this);
            this.sum.removeFunction(((AIDAFunctionAdapter)f).function());
            this.mapParams();
        }

        @Override
        public void update(Observable obs, Object arg) {
            if ("remove".equals(arg)) {
                this.removeFunction((Basic1DFunction)obs);
            }
            this.mapParams();
            this.clearFit();
            this.setChanged();
        }

        private void mapParams() {
            int j = 0;
            boolean i = false;
            this.m_nParams = 0;
            int nFuncs = 0;
            Enumeration e = this.jasHist().get1DFunctions();
            while (e.hasMoreElements()) {
                JASHistData data = (JASHistData)e.nextElement();
                Basic1DFunction func = (Basic1DFunction)data.getDataSource();
                if (func == this || !this.containsFunction(func)) continue;
                ++nFuncs;
            }
            this.m_param = new int[nFuncs];
            Enumeration en = this.jasHist().get1DFunctions();
            while (en.hasMoreElements()) {
                JASHistData data = (JASHistData)en.nextElement();
                Basic1DFunction func = (Basic1DFunction)data.getDataSource();
                if (!this.containsFunction(func)) continue;
                int n = func.getStatisticNames().length;
                this.m_param[j++] = n;
                this.m_nParams += n;
            }
            this.initIncludeParametersInFit(this.m_nParams);
        }

        JASHist jasHist() {
            return this.h;
        }

        public void openAdvancedDialog(Frame f, JASHist hist) {
            new SumOfFunctionsAdvancedDialog(f);
        }

        private class SumOfFunctionsAdvancedDialog
        extends JASDialog {
            SumOfFunctionsAdvancedDialog(Frame f) {
                super(f, "Advanced...", true, 1);
                int n = 0;
                Enumeration e = SumOfFunctions.this.jasHist().get1DFunctions();
                while (e.hasMoreElements()) {
                    JASHistData data = (JASHistData)e.nextElement();
                    Basic1DFunction func = (Basic1DFunction)data.getDataSource();
                    if (func == SumOfFunctions.this) continue;
                    ++n;
                }
                Container c = this.getContentPane();
                JCheckBox[] cb = new JCheckBox[n];
                c.setLayout(new GridLayout(n + 1, 1));
                c.add(new JLabel("Select functions to include:"));
                Enumeration en = SumOfFunctions.this.jasHist().get1DFunctions();
                int count = 0;
                while (en.hasMoreElements()) {
                    JASHistData data = (JASHistData)en.nextElement();
                    Basic1DFunction func = (Basic1DFunction)data.getDataSource();
                    if (func == SumOfFunctions.this) continue;
                    cb[count] = new JCheckBox(String.valueOf(count + 1) + " " + func.getTitle(), SumOfFunctions.this.containsFunction(func));
                    cb[count].addActionListener(new EnumeratedJCheckBoxListener(count, func));
                    cb[count].setMnemonic(48 + (char)(count + 1));
                    c.add(cb[count]);
                    ++count;
                }
                this.pack();
                this.setResizable(false);
                this.show();
            }

            private class EnumeratedJCheckBoxListener
            implements ActionListener {
                private int i;
                private Basic1DFunction func;

                EnumeratedJCheckBoxListener(int i, Basic1DFunction func) {
                    this.i = i;
                    this.func = func;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SumOfFunctions.this.containsFunction(this.func)) {
                        SumOfFunctions.this.addFunction(this.func);
                    } else {
                        SumOfFunctions.this.removeFunction(this.func);
                    }
                    SumOfFunctions.this.mapParams();
                    SumOfFunctions.this.setChanged();
                    SumOfFunctions.this.clearFit();
                }
            }
        }
    }
}

