/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLoginService;

public class AgentLockServiceCommands {
    private final AgentLockService als;
    private final AgentLoginService loginService;
    private final RouteSelectionCommandSet rsc;

    AgentLockServiceCommands(AgentLockService als, AgentLoginService loginService, RouteSelectionCommandSet rsc) {
        this.als = als;
        this.loginService = loginService;
        this.rsc = rsc;
    }

    @Deprecated
    @Command(description="Set this agent's authorized operational level for the given subsystem", type=Command.CommandType.QUERY)
    public void setLevel(@Argument(allowedValueProvider="getAllLockedOrLockableAgents") String agentName, int level) throws Exception {
        System.out.println("DEPRECATED: use \"set level AGENT_NAME LEVEL\" instead");
        this.als.setLevelForAgent(agentName, level);
    }

    @Deprecated
    @Command(description="Get this agent's authorized operatinal level for the given subsystem", type=Command.CommandType.QUERY)
    public int getLevel(@Argument(allowedValueProvider="getAllLockedOrLockableAgents") String agentName) {
        System.out.println("DEPRECATED: use \"get level AGENT_NAME\" instead");
        return this.als.getLevelForAgent(agentName);
    }

    @Command(description="Set the level of an agent", level=0, type=Command.CommandType.QUERY)
    public void set(@Argument(name="item") SetGetLevelCommands what, @Argument(allowedValueProvider="getAllLockedOrLockableAgents") String agentName, int level) throws Exception {
        switch (what) {
            case LEVEL: {
                this.als.setLevelForAgent(agentName, level);
            }
        }
    }

    @Command(description="Set the level of an agent", level=0, type=Command.CommandType.QUERY)
    public void set(@Argument(name="item") SetGetLevelCommands what, int level) throws Exception {
        String agentName = this.rsc.getActiveRoute();
        if (agentName.contains("/")) {
            agentName = agentName.substring(0, agentName.indexOf("/"));
        }
        this.set(what, agentName, level);
    }

    @Command(description="Get the level of an agent", level=0, type=Command.CommandType.QUERY)
    public int get(@Argument(name="item") SetGetLevelCommands what, @Argument(allowedValueProvider="getAllLockedOrLockableAgents") String agentName) throws Exception {
        switch (what) {
            case LEVEL: {
                return this.als.getLevelForAgent(agentName);
            }
        }
        return -1;
    }

    @Command(description="Get the level of an agent", level=0, type=Command.CommandType.QUERY)
    public int get(@Argument(name="item") SetGetLevelCommands what) throws Exception {
        String agentName = this.rsc.getActiveRoute();
        if (agentName.contains("/")) {
            agentName = agentName.substring(0, agentName.indexOf("/"));
        }
        return this.get(what, agentName);
    }

    @Command(description="Lock the given subsystem", type=Command.CommandType.QUERY)
    public void lock(@Argument(allowedValueProvider="getLockableAgents", defaultValue="CurrentTarget") String agentName) throws Exception {
        if ("CurrentTarget".equals(agentName) && (agentName = this.rsc.getActiveRoute()).contains("/")) {
            agentName = agentName.substring(0, agentName.indexOf("/"));
        }
        this.als.lockAgent(agentName);
    }

    @Command(description="Unlock the given subsystem", type=Command.CommandType.QUERY)
    public void unlock(@Argument(allowedValueProvider="getLockedAgents", defaultValue="CurrentTarget") String agentName) throws Exception {
        if ("CurrentTarget".equals(agentName) && (agentName = this.rsc.getActiveRoute()).contains("/")) {
            agentName = agentName.substring(0, agentName.indexOf("/"));
        }
        this.als.unlockAgent(agentName);
    }

    @Command(description="Attach the lock on the given subsystem to the current agent", type=Command.CommandType.QUERY)
    public void attachLock(@Argument(allowedValueProvider="getAttachableAgents", defaultValue="CurrentTarget") String agentName) throws Exception {
        if ("CurrentTarget".equals(agentName) && (agentName = this.rsc.getActiveRoute()).contains("/")) {
            agentName = agentName.substring(0, agentName.indexOf("/"));
        }
        this.als.attachLock(agentName);
    }

    @Command(description="Detach the lock on the given subsystem from the current agent", type=Command.CommandType.QUERY)
    public void detachLock(@Argument(allowedValueProvider="getDetachableAgents", defaultValue="CurrentTarget") String agentName) throws Exception {
        if ("CurrentTarget".equals(agentName) && (agentName = this.rsc.getActiveRoute()).contains("/")) {
            agentName = agentName.substring(0, agentName.indexOf("/"));
        }
        this.als.detachLock(agentName);
    }

    @Command(description="List subsystems locked by the current user", type=Command.CommandType.QUERY)
    public List<String> getLockedAgents() {
        return this.als.getLockedAgents();
    }

    @Command(description="Unlock the given subsystem, even if it is locked by another user", type=Command.CommandType.QUERY)
    public void destroyLock(@Argument(defaultValue="CurrentTarget") String agentName) throws Exception {
        if ("CurrentTarget".equals(agentName) && (agentName = this.rsc.getActiveRoute()).contains("/")) {
            agentName = agentName.substring(0, agentName.indexOf("/"));
        }
        this.als.destroyLock(agentName, this.als.getUserId());
    }

    @Command(description="List subsystems that are currently online and can be locked", type=Command.CommandType.QUERY)
    public List<String> getLockableAgents() {
        return this.als.getLockableAgents();
    }

    @Command(description="List locked subsystems that could be attached to the current agent", type=Command.CommandType.QUERY)
    public List<String> getAttachableAgents() {
        return this.als.getAttachableAgents();
    }

    @Command(description="List locked and attached subsystems that could be detached from the current agent", type=Command.CommandType.QUERY)
    public List<String> getDetachableAgents() {
        return this.als.getDetachableAgents();
    }

    public List<String> getAllLockedOrLockableAgents() {
        TreeSet all = new TreeSet(this.als.getLockableAgents());
        all.addAll(this.als.getAllLockedAgents());
        return new ArrayList<String>(all);
    }

    @Command(description="Show lock for the specified subsystem", type=Command.CommandType.QUERY)
    public String showLock(@Argument(allowedValueProvider="getAllLockedOrLockableAgents", defaultValue="CurrentTarget") String agentName) {
        if ("CurrentTarget".equals(agentName) && (agentName = this.rsc.getActiveRoute()).contains("/")) {
            agentName = agentName.substring(0, agentName.indexOf("/"));
        }
        if (agentName.trim().isEmpty()) {
            return "Subsystem not specified";
        }
        AgentLock lock = this.als.getExistingLockForAgent(agentName);
        if (lock == null) {
            return "Unlocked";
        }
        StringBuilder sb = new StringBuilder().append("Locked by ").append(lock.getOwner());
        if (lock instanceof AgentLockInfo) {
            AgentLockInfo lockInfo = (AgentLockInfo)lock;
            Instant time = lockInfo.getTimeStamp().getUTCInstant();
            sb.append(" since ").append(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault()).format(time));
        }
        return sb.append(".").toString();
    }

    @Command(description="List all locks owned by the specified user. If no user name is given, list locks owned by the current user.", type=Command.CommandType.QUERY)
    public String showLocks(@Argument(defaultValue="") String user) {
        if (user == null || user.trim().isEmpty()) {
            user = this.loginService.getUserId();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Locks owned by user ").append(user).append(":\n");
        for (String subsystem : this.als.getLockedAgents()) {
            AgentLock lock = this.als.getExistingLockForAgent(subsystem);
            if (lock == null) continue;
            sb.append(subsystem).append(" => Token = ").append(lock.getToken()).append("\n");
        }
        return sb.toString();
    }

    @Command(description="List attached locks", type=Command.CommandType.QUERY)
    public String showLocalLocks() {
        StringBuilder sb = new StringBuilder();
        for (String subsystem : this.als.getDetachableAgents()) {
            AgentLock lock = this.als.getExistingLockForAgent(subsystem);
            if (lock == null) continue;
            sb.append(subsystem).append(" => Token = ").append(lock.getToken()).append("\n");
        }
        return sb.toString();
    }

    @Command(description="List all existing locks", type=Command.CommandType.QUERY)
    public String showAllLocks() {
        TreeMap<String, AgentLock> locks = new TreeMap<String, AgentLock>(this.als.getLocks());
        StringBuilder sb = new StringBuilder();
        locks.forEach((agent, lock) -> {
            if (lock != null) {
                sb.append((String)agent).append(" : ").append(lock.getOwner()).append("\n");
            }
        });
        return sb.toString();
    }

    @Command(description="Set a specific user ID for the current console", type=Command.CommandType.QUERY)
    public void login(String userId) throws Exception {
        this.loginService.login(userId, null);
    }

    @Command(description="Disconnect the user ID from the current console", type=Command.CommandType.QUERY)
    public void logout() throws Exception {
        this.loginService.disconnect();
    }

    @Command(description="Display current user ID", type=Command.CommandType.QUERY)
    public String whoami() throws Exception {
        return this.loginService.getUserId();
    }

    public static enum SetGetLevelCommands {
        LEVEL;

    }
}

