package org.lsst.ccs.subsystems.console;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.LogAggregator;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.StatusMessageListener;

public class LogTracer extends Subsystem implements LogMessageListener {

    public static void main(String[] args) {
        LogTracer t = new LogTracer();
        if (args.length > 0) {
            // t.setName("statusTracer");
            t.getMessagingAccess().addStatusMessageListener(statusListener);
        }
        t.startAgent();
    }

    public LogTracer() {
        super("logtracer", AgentInfo.AgentType.LISTENER);

        LogAggregator la = new LogAggregator();
        getMessagingAccess().addLogMessageListener(la);
        la.stream().forEach(
                m -> System.out.printf("%-15s : %s", m.getOriginAgentInfo()
                        .getName(), m.getFormattedDetails()));

        // getMessagingAccess().addLogMessageListener(this);
    }

    private static final StatusMessageListener statusListener = new StatusMessageListener() {
        @Override
        public void onStatusMessage(StatusMessage s) {
            // System.out.println("onStatusMessage Begin");
            System.out.println(s);
            // System.out.println("onStatusMessage End\n");
        }
    };

    @Override
    public void onLogMessage(LogMessage logEvent) {
        System.out.println("Log from "
                + logEvent.getOriginAgentInfo().getName() + ":" + logEvent);
    }
}
