package org.lsst.ccs.subsystems.console.jython;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

/**
 *
 * @author The LSST CCS Team
 */
final class JythonConsoleResult implements Callable<String> {

    private final BufferedReader reader;
    private final StringBuffer buffer = new StringBuffer();
    private final String contentId;
    private final FutureTask<String> future;
    private final PrintStream out;

    JythonConsoleResult(BufferedReader reader, String contentId, PrintStream out) {
        this.reader = reader;
        this.contentId = contentId;
        future = new FutureTask<>(this);
        this.out = out;
    }

    @Override
    public String call() throws Exception {
        String line;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.contains("doneExecution:" + contentId)) {
                    break;
                } else {
                    buffer.append(line + "\n");
                    if ( out != null ) {
                        out.println(line);
                    }
                }
            }
        } catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
//        System.out.println(future.isDone());
        return buffer.toString();
    }

    String getResult() {
        try {
            return future.get();
        } catch (ExecutionException | InterruptedException ee) {
            throw new RuntimeException(ee);
        }

    }

    FutureTask<String> getFuture() {
        return future;
    }
}
