/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.services.AgentCommandDictionaryService;

public class DumpCommands
extends Agent {
    private static final Pattern RebPattern = Pattern.compile("R(\\d\\d)/Reb(.)");
    private static final Pattern SensorPattern = Pattern.compile("R(\\d\\d)/Reb(.)/S(.\\d)");
    private static final Pattern BiasPattern = Pattern.compile("R(\\d\\d)/Reb(.)/Bias(\\d)");
    private static final Pattern BiasOrDACPattern = Pattern.compile("R(\\d\\d)/Reb(.)/(Bias(\\d)|DAC)");
    private static final Pattern AspicPattern = Pattern.compile("R(\\d\\d)/Reb(.)/S(.\\d)/ASPIC(\\d)");
    private static final Pattern PowerSupplyPattern = Pattern.compile("RebPS/P(\\d\\d)");
    private static final Pattern CryoPattern = Pattern.compile("Cryo(\\d)");
    private static final Pattern CryoMaq20Pattern = Pattern.compile("Cryo(\\d)/Maq20");
    private static final Pattern ColdPattern = Pattern.compile("Cold(\\d)");
    private static Map<String, Pattern> specialPatterns = new HashMap<String, Pattern>();

    DumpCommands() {
        super("dump-commands", AgentInfo.AgentType.CONSOLE);
    }

    /*
     * Could not resolve type clashes
     */
    private String dumpDictionaryCommands() {
        Integer level;
        Integer level2;
        AgentInfo ai;
        AgentCommandDictionaryService dictService = (AgentCommandDictionaryService)this.getAgentService(AgentCommandDictionaryService.class);
        DictionaryListener listener = new DictionaryListener();
        dictService.addAgentCommandDictionaryListener((AgentCommandDictionaryService.AgentCommandDictionaryListener)listener);
        Map<AgentInfo, Map<String, Dictionary>> dictionaries = listener.getDictionaries();
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<AgentInfo, TreeMap> subsystemSpecificActionCommands = new LinkedHashMap<AgentInfo, TreeMap>();
        LinkedHashMap<AgentInfo, TreeMap> subsystemSpecificQueryCommands = new LinkedHashMap<AgentInfo, TreeMap>();
        TreeMap commonActionCommands = new TreeMap();
        TreeMap commonQueryCommands = new TreeMap();
        TreeMap<String, AgentInfo> sortedAgents = new TreeMap<String, AgentInfo>();
        for (AgentInfo ai2 : this.getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
            sortedAgents.put(ai2.getName(), ai2);
        }
        TreeSet<String> processedDescriptions = new TreeSet<String>();
        block11: for (AgentInfo ai3 : sortedAgents.values()) {
            String agentDescription = ai3.getAgentProperty("agentDescription");
            switch (agentDescription) {
                case "LocalDatabase": 
                case "ClusterMonitor": 
                case "Mmm": 
                case "Jas3Console": 
                case "LockManager": {
                    continue block11;
                }
            }
            if (!processedDescriptions.add(agentDescription)) continue;
            Map<String, Dictionary> dicts = dictionaries.get(ai3);
            if (dicts == null) {
                System.out.println("No dictionary for " + ai3.getName());
                continue;
            }
            for (Map.Entry<String, Dictionary> e : dicts.entrySet()) {
                String agentName = ai3.getName();
                String target = e.getKey().replace(agentName + "/", "").replace(agentName, "");
                block13: for (DictionaryCommand cmd : e.getValue()) {
                    Command.CommandCategory cat = cmd.getCategory();
                    Command.CommandType type = cmd.getType();
                    if (cmd.getCommandName().equals("getRaisedAlertSummary") || cmd.getCommandName().equals("printRegisteredAlerts") || cmd.getCommandName().equals("printAllLatestData")) {
                        cat = Command.CommandCategory.CORE;
                    }
                    if (cmd.getCommandName().equals("getChannelNames") && target.isEmpty()) {
                        cat = Command.CommandCategory.CORE;
                    }
                    if (cmd.getCommandName().equals("disableBackBias")) {
                        cat = Command.CommandCategory.USER;
                    }
                    CommandWrapper wrapper = new CommandWrapper(cmd);
                    TreeMap commandsSortedByLevel = cat == Command.CommandCategory.USER ? (type == Command.CommandType.QUERY ? subsystemSpecificQueryCommands.computeIfAbsent(ai3, a -> new TreeMap()) : subsystemSpecificActionCommands.computeIfAbsent(ai3, a -> new TreeMap())) : (type == Command.CommandType.QUERY ? commonQueryCommands : commonActionCommands);
                    int level3 = cmd.getLevel();
                    Set wrapperSet = commandsSortedByLevel.computeIfAbsent(level3, l -> new TreeSet());
                    wrapperSet.add(wrapper);
                    for (CommandWrapper wrp : wrapperSet) {
                        if (!wrp.equals(wrapper)) continue;
                        wrp.addTarget(target);
                        continue block13;
                    }
                }
            }
        }
        sb.append("Subsysem specific ACTION commands").append("\n\n");
        sb.append("|Subsystem|Level|Command|Description|Targets|\n");
        for (Map.Entry e : subsystemSpecificActionCommands.entrySet()) {
            ai = (AgentInfo)e.getKey();
            sb.append("|").append(ai.getAgentProperty("agentDescription")).append("| | | | |\n");
            for (Map.Entry e1 : ((TreeMap)e.getValue()).entrySet()) {
                level2 = (Integer)e1.getKey();
                sb.append("| |").append(level2).append("| | | |\n");
                for (CommandWrapper w : (Set)e1.getValue()) {
                    sb.append("| | |").append(w.commandName).append("|").append(w.getCommandDescription()).append("|").append(w.getTargets()).append("|\n");
                }
            }
        }
        sb.append("\n\nCommon ACTION commands").append("\n\n");
        sb.append("| |Level|Command|Description|Targets|\n");
        for (Map.Entry e1 : commonActionCommands.entrySet()) {
            level = (Integer)e1.getKey();
            sb.append("| |").append(level).append("| | | |\n");
            for (CommandWrapper w : (Set)e1.getValue()) {
                sb.append("| | |").append(w.commandName).append("|").append(w.getCommandDescription()).append("|").append(w.getTargets()).append("|\n");
            }
        }
        sb.append("\n\nSubsysem specific QUERY commands").append("\n\n");
        sb.append("|Subsystem|Level|Command|Description|Targets|\n");
        for (Map.Entry e : subsystemSpecificQueryCommands.entrySet()) {
            ai = (AgentInfo)e.getKey();
            sb.append("|").append(ai.getAgentProperty("agentDescription")).append("| | | | |\n");
            for (Map.Entry e1 : ((TreeMap)e.getValue()).entrySet()) {
                level2 = (Integer)e1.getKey();
                sb.append("| |").append(level2).append("| | | |\n");
                for (CommandWrapper w : (Set)e1.getValue()) {
                    sb.append("| | |").append(w.commandName).append("|").append(w.getCommandDescription()).append("|").append(w.getTargets()).append("|\n");
                }
            }
        }
        sb.append("\n\nCommon QUERY commands").append("\n\n");
        sb.append("| |Level|Command|Description|Targets|\n");
        for (Map.Entry e1 : commonQueryCommands.entrySet()) {
            level = (Integer)e1.getKey();
            sb.append("| |").append(level).append("| | | |\n");
            for (CommandWrapper w : (Set)e1.getValue()) {
                sb.append("| | |").append(w.commandName).append("|").append(w.getCommandDescription()).append("|").append(w.getTargets()).append("|\n");
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        DumpCommands agent = new DumpCommands();
        agent.startAgent();
        System.out.println("Wait 15 seconds to collect all dictionaries.");
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String commands = agent.dumpDictionaryCommands();
        Path filePath = Paths.get("commandsAndLevels.csv", new String[0]);
        try {
            Files.writeString(filePath, (CharSequence)commands, StandardOpenOption.CREATE);
            System.out.println("Commands written to file " + filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        agent.shutdownAgent();
        System.exit(0);
    }

    static {
        specialPatterns.put("R*/Reb*", RebPattern);
        specialPatterns.put("R*/Reb*/S*", SensorPattern);
        specialPatterns.put("R*/Reb*/Bias*", BiasPattern);
        specialPatterns.put("R*/Reb*/Bias* and R*/Reb*/DAC", BiasOrDACPattern);
        specialPatterns.put("R*/Reb*/S*/ASPIC*", AspicPattern);
        specialPatterns.put("RebPs/P*", PowerSupplyPattern);
        specialPatterns.put("Cryo*", CryoPattern);
        specialPatterns.put("Cryo*/Maq20", CryoMaq20Pattern);
        specialPatterns.put("Cold*", ColdPattern);
    }

    private class DictionaryListener
    implements AgentCommandDictionaryService.AgentCommandDictionaryListener {
        private Map<AgentInfo, Map<String, Dictionary>> dictionaries = new HashMap<AgentInfo, Map<String, Dictionary>>();

        private DictionaryListener() {
        }

        public void commandDictionaryUpdate(AgentCommandDictionaryService.AgentCommandDictionaryEvent evt) {
            if (evt.getEventType() == AgentCommandDictionaryService.AgentCommandDictionaryEvent.EventType.ADDED) {
                this.dictionaries.put(evt.getAgentInfo(), evt.getDictionary());
            }
        }

        Map<AgentInfo, Map<String, Dictionary>> getDictionaries() {
            return this.dictionaries;
        }
    }

    private static class CommandWrapper
    implements Comparable {
        public final String commandName;
        public final String commandDescription;
        public final int level;
        private final Command.CommandCategory category;
        private final Command.CommandType type;
        public final Set<String> targets = new TreeSet<String>();

        public CommandWrapper(DictionaryCommand cmd) {
            this.commandName = cmd.getCommandName();
            this.commandDescription = cmd.getDescription().replaceAll("\n", " ").replaceAll("\t", "").replace("|", "/");
            this.category = cmd.getCategory();
            this.type = cmd.getType();
            this.level = cmd.getLevel();
        }

        public boolean equals(Object obj) {
            CommandWrapper cw = (CommandWrapper)obj;
            return cw.commandName.equals(this.commandName) && cw.commandDescription.equals(this.commandDescription) && cw.level == this.level;
        }

        public int hashCode() {
            return 123 + this.commandName.hashCode() + 12 * this.commandDescription.hashCode() + 123 * (this.level + 3);
        }

        public void addTarget(String target) {
            this.targets.add(target);
        }

        public String getCommandDescription() {
            return this.commandDescription.isEmpty() ? " " : this.commandDescription;
        }

        public String getTargets() {
            String ret;
            if (this.type == Command.CommandType.CONFIGURATION && this.category != Command.CommandCategory.USER && this.targets.size() > 1) {
                return "Any Component with Configuration Parameters";
            }
            if (this.commandName.equals("getValue") && this.category == Command.CommandCategory.CORE) {
                return "All Channels";
            }
            if (this.commandName.equals("printComponentConfigurationParameters")) {
                return "All Components with Configuration Parameters";
            }
            if (this.targets.size() > 1) {
                for (Map.Entry<String, Pattern> e : specialPatterns.entrySet()) {
                    Pattern p = e.getValue();
                    boolean match = true;
                    for (String target : this.targets) {
                        if (p.matcher(target).matches()) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    return e.getKey();
                }
            }
            return (ret = this.targets.toString().replace("[", "").replace("]", "")).isEmpty() ? " " : ret;
        }

        public int compareTo(Object t) {
            CommandWrapper cw = (CommandWrapper)t;
            return this.commandName.compareTo(cw.commandName);
        }
    }
}

