/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.jython;

import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.ScriptingSubsystemWrapper;
import org.lsst.ccs.subsystems.console.jython.JythonConsoleSocketConnection;
import org.lsst.ccs.subsystems.console.jython.JythonInterpreterConsole;
import org.lsst.ccs.subsystems.console.jython.JythonScriptExecutor;
import org.lsst.ccs.test.subsystem.EchoSubsystem;
import org.lsst.ccs.test.subsystem.PublishSubsystem;

public class TestJythonInterpreter
extends CcsTestCaseTemplate {
    private static JythonInterpreterConsole interpreterConsole;
    private EchoSubsystem echoSub;
    private PublishSubsystem publishSub;
    private ScriptingSubsystemWrapper echoSubWrapper;
    private ScriptingSubsystemWrapper publishSubWrapper;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.setProperty("org.lsst.ccs.subsystem.console.jython.interpreter.max.sockets", "2");
        interpreterConsole = new JythonInterpreterConsole(4444);
        interpreterConsole.startAgent();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        interpreterConsole.shutdownAgent();
    }

    @Before
    public void initalizeSubsystems() {
        CCS.initializeScriptingEnvironment();
        this.echoSub = new EchoSubsystem("echoSub");
        this.echoSub.startAgent();
        this.publishSub = new PublishSubsystem("publishSub");
        this.publishSub.startAgent();
    }

    @After
    public void shutdowSubsystems() throws Exception {
        this.echoSub.shutdownAgent();
        this.publishSub.shutdownAgent();
        CCS.shutdownScriptingEnvironment();
    }

    @Test
    public void testMaxNumberOfSocketConnections() throws Exception {
        Thread.sleep(1000L);
        JythonConsoleSocketConnection connection1 = new JythonConsoleSocketConnection("ABC");
        JythonConsoleSocketConnection connection2 = new JythonConsoleSocketConnection("DEF");
        try {
            JythonConsoleSocketConnection connection3 = new JythonConsoleSocketConnection("GGG");
            Assert.assertTrue((boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection1.close();
        connection2.close();
    }

    @Test
    public void testConsole() throws Exception {
        Thread.sleep(1000L);
        JythonConsoleSocketConnection connection = new JythonConsoleSocketConnection("someConnection");
        String result = null;
        for (int i = 0; i < 10; ++i) {
            String tmpResult = connection.synchFileExecution("org/lsst/ccs/subsystems/console/jython/loop.py", new String[0]);
            if (result == null) {
                result = tmpResult;
                continue;
            }
            Assert.assertEquals((Object)tmpResult, (Object)result);
        }
        connection.close();
    }

    @Test
    public void testMultipleExecutions() throws Exception {
        JythonConsoleSocketConnection connection = new JythonConsoleSocketConnection("someConnection");
        String tmpResult = connection.synchFileExecution("org/lsst/ccs/scripting/jython/sendingCommands.py", new String[0]);
        Assert.assertEquals((Object)"OK", (Object)tmpResult.replace("\n", ""));
        connection.synchFileExecution("org/lsst/ccs/scripting/jython/sendingCommands.py", new String[0]);
        Assert.assertEquals((Object)"OK", (Object)tmpResult.replace("\n", ""));
        connection.close();
    }

    @Test
    public void testScriptArgumentPassing() throws Exception {
        String[] args = new String[]{"~/testing.jy", "-exp", "10"};
        JythonScriptExecutor.parseCommandLineArguments((String[])args);
        List argList = JythonScriptExecutor.getLeftoverArguments();
        Assert.assertTrue((argList.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals(argList.get(0), (Object)args[0]);
        Assert.assertEquals(argList.get(1), (Object)args[1]);
        Assert.assertEquals(argList.get(2), (Object)args[2]);
    }
}

