/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class Factory {
    private Factory() {
    }

    public static String findFactory(String factoryName, String factoryFile, String defaultFactory) {
        String factory = null;
        try {
            factory = System.getProperty(factoryName);
            if (factory != null) {
                return factory;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            String javaHome = System.getProperty("java.home");
            String configFile = javaHome + File.separator + "lib" + File.separator + factoryFile;
            File file = new File(configFile);
            if (file.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(file));
                factory = props.getProperty(factoryName);
                if (factory != null) {
                    return factory;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String service1 = "meta-inf/services/" + factoryName;
        String service2 = "META-INF/services/" + factoryName;
        try {
            ClassLoader loader = null;
            try {
                loader = Class.forName("org.freehep.util.Factory").getClassLoader();
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
            InputStream stream = null;
            stream = loader == null ? ClassLoader.getSystemResourceAsStream(service1) : loader.getResourceAsStream(service1);
            if (stream == null) {
                stream = loader == null ? ClassLoader.getSystemResourceAsStream(service2) : loader.getResourceAsStream(service2);
            }
            if (stream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                factory = reader.readLine();
                reader.close();
                if (factory != null && !factory.equals("")) {
                    return factory;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultFactory;
    }

    public static Object loadFactory(String name, String file, String defaultImplementation) {
        String factoryName = Factory.findFactory(name, file, defaultImplementation);
        try {
            System.out.println("Loading factory: " + factoryName);
            Class<?> factoryClass = Class.forName(factoryName);
            return factoryClass.newInstance();
        }
        catch (Exception e) {
            System.err.println("Unable to load factory: " + factoryName);
            e.printStackTrace();
            return null;
        }
    }
}

