/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.jython;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.subsystems.console.jython.JythonConsoleSocketConnection;

public class JythonScriptExecutor {
    private static CommandLine line;
    static Options shellOptions;

    public static void main(String[] args) throws ParseException, FileNotFoundException, IOException {
        JythonScriptExecutor.parseCommandLineArguments(args);
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(80, "ccs-script", "", shellOptions, "", true);
        } else {
            List argList = line.getArgList();
            String scriptPath = argList.isEmpty() ? null : (String)argList.remove(0);
            boolean submit = line.hasOption("submit");
            if (submit) {
                int port = 4444;
                if (line.hasOption("jythonPort")) {
                    port = Integer.parseInt(line.getOptionValue("jythonPort"));
                }
                String host = "localhost";
                if (line.hasOption("jythonHost")) {
                    host = line.getOptionValue("jythonHost");
                }
                InputStream is = JythonScriptExecutorUtils.getScriptInputStream((String)scriptPath);
                JythonConsoleSocketConnection jythonConsoleSocketConnection = new JythonConsoleSocketConnection("ScriptSubmission_" + System.currentTimeMillis(), port, host);
                jythonConsoleSocketConnection.setPrintStream(System.out);
                jythonConsoleSocketConnection.synchFileExecution(is, argList.toArray(new String[0]));
                jythonConsoleSocketConnection.close();
            } else if (scriptPath == null) {
                JythonScriptExecutorUtils.executeInteractive();
            } else {
                InputStream is = JythonScriptExecutorUtils.getScriptInputStream((String)scriptPath);
                try {
                    JythonScriptExecutorUtils.executeScript((InputStream)is, (String)scriptPath, (OutputStream)System.out, (String[])argList.toArray(new String[0]));
                }
                catch (Throwable t) {
                    JythonScriptExecutorUtils.handleExecutionException((Throwable)t);
                }
            }
        }
        System.exit(0);
    }

    static void parseCommandLineArguments(String[] args) throws ParseException {
        shellOptions = new Options();
        shellOptions.addOption("h", "help", false, "Print the help message");
        shellOptions.addOption("jhost", "jythonHost", true, "The host of the JythonInterpreterConsole");
        shellOptions.addOption("jport", "jythonPort", true, "The port of the JythonInterpreterConsole");
        shellOptions.addOption("submit", false, "Submit the script to a JythonInterpreterConsole");
        BasicParser parser = new BasicParser();
        line = parser.parse(shellOptions, args, true);
    }

    static List<String> getLeftoverArguments() {
        return line.getArgList();
    }
}

