/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.ConsoleCommandShell;

public class TestDictionaryCommandLevel
extends CcsTestCaseTemplate {
    @Test
    public void testDictionaryCommandsVisibility() throws Exception {
        Subsystem s = BootUtils.getSubsystemFromFile((String)"simpleModuleWithDeepStructure");
        String sName = s.getName();
        s.startAgent();
        ((AgentStateService)s.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 10L, TimeUnit.SECONDS);
        Subsystem busMaster = new Subsystem("console", AgentInfo.AgentType.CONSOLE);
        busMaster.startAgent();
        ((AgentStateService)busMaster.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 10L, TimeUnit.SECONDS);
        ConsoleCommandShell comShell = new ConsoleCommandShell((Agent)busMaster);
        JLineShell shell = new JLineShell((CommandSet)comShell.getConsoleCommandSet(), "${target} ccs>");
        Thread.sleep(1000L);
        TokenizedCommand locktc = new TokenizedCommand("lock " + sName);
        int finds = 0;
        for (CommandSet cs : comShell.getConsoleCommandSet().getCommandSets()) {
            if (cs.getCommandDictionary().findCommand((BasicCommand)locktc) == null) continue;
            Dictionary d = cs.getCommandDictionary();
            DictionaryCommand l = d.findCommand((BasicCommand)locktc);
            Assert.assertNotNull((Object)l);
            Assert.assertTrue((boolean)d.isDictionaryCommandVisible(l));
            ++finds;
        }
        Assert.assertEquals((long)1L, (long)finds);
        TokenizedCommand tc = new TokenizedCommand("setLogLevel some.logger WARNING");
        Dictionary sDict = ((CommandSet)comShell.getConsoleCommandSet().getCommandSetsForRoute(sName).get(sName)).getCommandDictionary();
        DictionaryCommand setLogLevel = sDict.findCommand((BasicCommand)tc);
        Assert.assertNotNull((Object)setLogLevel);
        boolean isVisible = sDict.isDictionaryCommandVisible(setLogLevel);
        Assert.assertEquals((long)0L, (long)setLogLevel.getLevel());
        Assert.assertEquals((Object)Command.CommandType.QUERY, (Object)setLogLevel.getType());
        Assert.assertTrue((boolean)isVisible);
        TokenizedCommand setTarget = new TokenizedCommand("set target " + sName);
        Dictionary topLevelDict = comShell.getConsoleCommandSet().getCommandDictionary();
        DictionaryCommand setTargetDictCmd = topLevelDict.findCommand((BasicCommand)setTarget);
        Assert.assertEquals((Object)Command.CommandType.QUERY, (Object)setTargetDictCmd.getType());
        Assert.assertEquals((long)0L, (long)setTargetDictCmd.getLevel());
        Assert.assertTrue((boolean)topLevelDict.isDictionaryCommandVisible(setTargetDictCmd));
        s.shutdownAgent();
        busMaster.shutdownAgent();
    }
}

