
package org.lsst.ccs.subsystems.console.jython;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;

/**
 *
 * @author The LSST CCS Team
 */
public final class JythonConsoleSocketConnection {
    
    private final Socket consoleSocketConnection;
    private final PrintWriter out;

    private final ExecutorService executor = Executors.newCachedThreadPool();    
    private PrintStream print = null;
    
    JythonConsoleSocketConnection(String name) throws UnknownHostException, IOException {
        this(name, 4444, "localhost");
    }
    
    public JythonConsoleSocketConnection(String name, int port, String host) throws UnknownHostException, IOException {
        consoleSocketConnection = new Socket(host, port);
        out = new PrintWriter(consoleSocketConnection.getOutputStream(),true);
        synchLineExecution("initializeInterpreter "+name);
    }
    
    public void setPrintStream(PrintStream print) {
        this.print = print;
    }
    
    String synchLineExecution(String line) throws IOException {
        JythonConsoleResult result = asynchLineExecution(line);
        return result.getResult();
    }

    String synchFileExecution(String fileName, String... args) throws IOException {
        JythonConsoleResult result = asynchFileExecution(fileName, args);
        return result.getResult();
    }
    
    public String synchFileExecution(InputStream is, String... args) throws IOException {
        JythonConsoleResult result = asynchFileExecution(is, args);
        return result.getResult();
    }
    
    JythonConsoleResult asynchLineExecution(String buffer) throws IOException {
        String contentId = String.valueOf(System.currentTimeMillis());
        JythonConsoleResult result = new JythonConsoleResult(new BufferedReader( new InputStreamReader( consoleSocketConnection.getInputStream() )),contentId, print);
        out.println("startContent:"+contentId);
        out.println(buffer);
        out.println("endContent:"+contentId);
        executor.execute(result.getFuture());
        return result;
    }
    
    public JythonConsoleResult asynchFileExecution(String fileName, String... args) throws IOException {
        InputStream is = BootstrapResourceUtils.getBootstrapResource(fileName);
        if ( is == null ) {
            is = new FileInputStream(fileName);
        }
        return asynchFileExecution(is, args);
    }
    
    private JythonConsoleResult asynchFileExecution(InputStream in, String... args) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
        StringBuilder stringBuffer = new StringBuilder();
        String line;
        stringBuffer.append(JythonScriptExecutorUtils.getArgumentSettingCode("-",args));
        while((line =bufferedReader.readLine())!=null){
            stringBuffer.append(line).append("\n");
        }   
        return asynchLineExecution(stringBuffer.toString());
    }
    
    
    public void close() throws IOException {
        consoleSocketConnection.close();
    }
    
    public static void main(String[] arg) throws Exception {
        JythonConsoleSocketConnection connection = new JythonConsoleSocketConnection("ABC");
        
        Thread.sleep(5000);
        
        
        connection.close();
        
    }
    
    
    
}
