/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.concurrent.TimeUnit;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.config.ConfigurationParameterDescription;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.PeriodicTaskComponent;
import org.lsst.ccs.utilities.scheduler.Scheduler;

class FixedDelayPeriodicTaskComponent
extends PeriodicTaskComponent {
    @ConfigurationParameter(category="timers", description="Parameter that defines when a long execution Alert should be raised", units="ms or unitless")
    private volatile long longExecutionDelay = -1L;

    FixedDelayPeriodicTaskComponent(AgentPeriodicTask taskDefinition, Scheduler scheduler, AgentPeriodicTaskService.AgentPeriodicTaskExceptionHandler handler) {
        super(taskDefinition, scheduler, handler);
    }

    @Override
    public ConfigurationParameterDescription getConfigurationParameterDescription(String parName) {
        if (parName.equals("longExecutionDelay")) {
            return null;
        }
        return super.getConfigurationParameterDescription(parName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigurationParameterChanger(propertyName="longExecutionDelay")
    public void setLongExecutionDelay(long longExecutionDelay) {
        Object object = this.taskLock;
        synchronized (object) {
            this.longExecutionDelay = longExecutionDelay;
            this.handler.setLongExecutionThreshold((int)Math.abs(longExecutionDelay), longExecutionDelay > 0L ? TimeUnit.MILLISECONDS : null);
        }
    }
}

