/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ChecksumUtils;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusCommandDictionary;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.BusMessagePreProcessor;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentDictionaryCommand;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.RemoteDictionaryDAO;
import org.lsst.ccs.services.alert.AlertService;

public class AgentCommandDictionaryService
implements ServiceLifecycle,
AgentService,
BusMessagePreProcessor {
    private static final Logger log = Logger.getLogger("org.lsst.ccs.services.command.dictionary");
    private final LinkedHashMap<String, CommandSet> commandSetMap = new LinkedHashMap();
    HashMap<String, Dictionary> dictionaries = null;
    private byte[] serializedDictionaries;
    private List<String> commandTargets = null;
    private volatile boolean canAddDictionaries = false;
    private final ReentrantLock dictionaryUpdateLock = new ReentrantLock();
    private final HashMap<String, AgentInfo> agentInfos = new HashMap();
    private final HashMap<String, HashMap<String, Dictionary>> agentDictionaries = new HashMap();
    private final ArrayList<AgentCommandDictionaryListener> listeners = new ArrayList(2);
    private long dictionaryChecksum = -1L;
    private ClientSideAgentCommandDictionaryBookkeeper bookkeeper = null;
    private volatile ConcurrentMessagingUtils cmu;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Agent topLevelAgent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    private static final String USE_REMOTE_COMMAND_DICTIONARY = "use.remote.command.dictionary";
    private RemoteDictionaryDAO remoteDAO;
    public static final SupportedOption withLockOption = new SupportedOption("withLock", "Execute this command without acquiring a lock on a non-locked target", "");
    private final List<AgentInfo> processingDictionaries = new CopyOnWriteArrayList<AgentInfo>();

    @Override
    public String getAgentServiceName() {
        return "commandDictionaryService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return true;
    }

    @Override
    public void preBuild() {
        Properties p = BootstrapResourceUtils.getBootstrapSystemProperties();
        if (p.getProperty("org.lsst.ccs.remote.dictionary", "false").toLowerCase().equals("true")) {
            log.log(Level.INFO, "Using remote service for Command Dictionary");
            this.remoteDAO = new RemoteDictionaryDAO(this.topLevelAgent.getDescription(), "dictionaries");
            this.agentPropertiesService.setAgentProperty(USE_REMOTE_COMMAND_DICTIONARY, "true");
        }
    }

    @Override
    public void afterBuild() {
        this.canAddDictionaries = true;
    }

    private static boolean isShellOrGraphicalConsole(AgentInfo agentInfo) {
        return agentInfo.getType() == AgentInfo.AgentType.CONSOLE && !agentInfo.isScriptingConsole();
    }

    @Override
    public void afterInit() {
        TreeWalkerUtils.proceduralNodeWalk(this.topLevelAgent.getComponentLookup(), this.topLevelAgent.getComponentLookup().getComponentNodeForObject((Object)this.topLevelAgent), n -> {
            Object o;
            Object objectToAddTo = o = n.getComponent();
            if (o instanceof Monitor || o instanceof ConfigurationService || o instanceof AlertService || o instanceof PersistencyService) {
                objectToAddTo = this.topLevelAgent;
            }
            this.addCommandSetToObject(o, objectToAddTo);
        }, null);
        this.addCommandSetToObject(new AgentCommandDictionaryCommands(), this.topLevelAgent);
        this.dictionaries = new LinkedHashMap<String, Dictionary>(this.commandSetMap.size() * 2);
        this.commandSetMap.forEach((name, commandSet) -> {
            Dictionary dict = commandSet.getCommandDictionary();
            for (Map.Entry<String, Dictionary> d : this.dictionaries.entrySet()) {
                if (!DictionaryUtils.areDictionariesEqual((Dictionary)d.getValue(), (Dictionary)dict)) continue;
                dict = d.getValue();
                break;
            }
            String descName = name.replaceFirst(this.topLevelAgent.getName(), "");
            this.dictionaries.put(descName, dict);
        });
        this.commandTargets = new ArrayList<String>(this.commandSetMap.size() * 2);
        this.commandSetMap.forEach((name, commandSet) -> this.commandTargets.add((String)name));
        this.canAddDictionaries = false;
        this.dictionaryChecksum = ChecksumUtils.evaluateChecksum(this.dictionaries);
        AgentInfo agentInfo = this.topLevelAgent.getAgentInfo();
        agentInfo.getAgentProperties().setProperty(this.getDictionaryChecksumProperty(), String.valueOf(this.dictionaryChecksum));
        String dictionaryType = null;
        if (agentInfo.isGraphicalConsole()) {
            dictionaryType = "console";
        } else if (agentInfo.isScriptingConsole()) {
            dictionaryType = "scripting";
        } else if (agentInfo.getType() == AgentInfo.AgentType.CONSOLE) {
            dictionaryType = "shell";
        }
        if (dictionaryType != null) {
            agentInfo.getAgentProperties().setProperty(this.getDictionaryTypeProperty(), dictionaryType);
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             GZIPOutputStream gzipOut = new GZIPOutputStream(bos);){
            try (ObjectOutputStream oos = new ObjectOutputStream(gzipOut);){
                oos.writeObject(this.dictionaries);
                oos.flush();
            }
            this.serializedDictionaries = bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem serializing the dictionaries.", ioe);
        }
        if (AgentCommandDictionaryService.isShellOrGraphicalConsole(agentInfo)) {
            this.bookkeeper = new ClientSideAgentCommandDictionaryBookkeeper();
            this.topLevelAgent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.bookkeeper, BusMessageFilterFactory.messageClass(StatusCommandDictionary.class));
            this.topLevelAgent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.bookkeeper);
            this.agentLockService.addAgentLockUpdateListener(this.bookkeeper);
        }
        if (this.remoteDAO != null) {
            String dictionaryName = this.buildDataDictionaryName(agentInfo);
            if (this.bookkeeper != null) {
                this.bookkeeper.addCompressedDictionary(dictionaryName, this.serializedDictionaries);
            }
            try {
                this.remoteDAO.writeDictionaryIfNeeded(dictionaryName, this.serializedDictionaries);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.topLevelAgent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)new AgentPublishDictionaryStrategy());
    }

    private String getDictionaryChecksumProperty() {
        return this.getClass().getSimpleName() + ":checksum";
    }

    private String getDictionaryTypeProperty() {
        return this.getClass().getSimpleName() + ":type";
    }

    private String buildDataDictionaryName(AgentInfo ai) {
        String dictType = ai.getAgentProperty(this.getDictionaryTypeProperty());
        String description = dictType != null ? dictType : ai.getAgentProperty("agentDescription");
        return "command/" + description + "/" + ai.getAgentProperty(this.getDictionaryChecksumProperty()) + ".ser";
    }

    public long getDictionaryChecksum() {
        return this.dictionaryChecksum;
    }

    public CommandSet getCommandSet(String name) {
        if (this.commandSetMap.containsKey(name)) {
            return this.commandSetMap.get(name);
        }
        String componentName = name.substring(name.lastIndexOf(47));
        for (Map.Entry<String, CommandSet> entry : this.commandSetMap.entrySet()) {
            if (!entry.getKey().endsWith(componentName)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void addCommandSetToObject(Object obj, Object objectToAddTo) {
        String fullPath;
        if (!this.canAddDictionaries) {
            throw new RuntimeException("Not possible to add a CommandSet at this point. Command sets can only be added in the HasLifecycle::init phase.");
        }
        CommandSet commandSet = new CommandSetBuilder().buildCommandSet(obj);
        String string = fullPath = objectToAddTo instanceof String ? (String)objectToAddTo : this.topLevelAgent.getComponentLookup().getComponentNodeForObject(objectToAddTo).getPath();
        if (commandSet.getCommandDictionary().size() == 0) {
            return;
        }
        if (fullPath == null) {
            fullPath = "";
        }
        int depth = !fullPath.isEmpty() ? fullPath.split("/").length : 0;
        Dictionary dict = commandSet.getCommandDictionary();
        for (DictionaryCommand c : dict) {
            for (Field field : c.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    int value;
                    if (field.getName().equals("level") && (value = ((Integer)field.get(c)).intValue()) == 99999) {
                        field.setInt(c, depth);
                        log.fine("Changing undefined level on command " + c.getCommandName() + " to value " + depth);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (this.topLevelAgent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0 && (c.getType() != Command.CommandType.QUERY || c.getLevel() != 0) && c.getSupportedOptions().contains(withLockOption)) continue;
            }
        }
        fullPath = this.topLevelAgent.getName() + (fullPath.isEmpty() || fullPath.startsWith("/") ? fullPath : "/" + fullPath);
        CompositeCommandSet cmdSet = (CompositeCommandSet)this.commandSetMap.getOrDefault(fullPath, (CommandSet)new CompositeCommandSet());
        cmdSet.add(commandSet);
        this.commandSetMap.put(fullPath, (CommandSet)cmdSet);
    }

    public HashMap<String, Dictionary> getAgentCommandDictionary() {
        return new LinkedHashMap<String, Dictionary>(StatusCommandDictionary.setTargetsForAgent(this.dictionaries, (String)this.topLevelAgent.getName()));
    }

    public HashMap<String, Dictionary> getAgentCommandDictionaryWithoutAgentName() {
        return new LinkedHashMap<String, Dictionary>(this.dictionaries);
    }

    private void publishAgentCommandDictionary() {
        log.log(Level.FINER, "Publising CommandDictionary");
        this.topLevelAgent.sendStatusMessage((StatusMessage)new StatusCommandDictionary(this.serializedDictionaries, "gzip"));
    }

    @Deprecated
    public AgentDictionaryCommand getAgentDictionaryCommand(String destination, String commandName, int nArgs) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentCommandDictionaryListener(AgentCommandDictionaryListener listener) {
        this.dictionaryUpdateLock.lock();
        try {
            for (Map.Entry<String, HashMap<String, Dictionary>> entry : this.agentDictionaries.entrySet()) {
                log.log(Level.FINER, "{0} listener joining notification for {1}", new Object[]{listener.getClass().getSimpleName(), entry.getKey()});
                AgentInfo ai = this.agentInfos.get(entry.getKey());
                listener.commandDictionaryUpdate(new AgentCommandDictionaryEvent(ai, AgentCommandDictionaryEvent.EventType.ADDED, entry.getValue()));
            }
            this.listeners.add(listener);
        }
        finally {
            this.dictionaryUpdateLock.unlock();
        }
    }

    public void removeAgentCommandDictionaryListener(AgentCommandDictionaryListener listener) {
        this.dictionaryUpdateLock.lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.dictionaryUpdateLock.unlock();
        }
    }

    private void notifyAgentCommandDictionaryListeners(AgentCommandDictionaryEvent evt) {
        for (AgentCommandDictionaryListener listener : this.listeners) {
            log.log(Level.FINER, "{0} listener (out of {1}) update notification for {2}: {3}", new Object[]{listener.getClass().getSimpleName(), this.listeners.size(), evt.getAgentInfo().getName(), evt.getEventType()});
            try {
                listener.commandDictionaryUpdate(evt);
            }
            catch (RuntimeException x) {
                log.log(Level.WARNING, "Error delivering AgentCommandDictionary notification", x);
            }
        }
    }

    public Bus getBus() {
        return Bus.STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusMessage preProcessMessage(BusMessage msg) {
        AgentInfo ai = msg.getOriginAgentInfo();
        if (!this.topLevelAgent.getName().equals(ai.getName()) && this.remoteDAO != null && !this.agentDictionaries.containsKey(ai.getName())) {
            log.log(Level.FINE, "Command: Processing message for {0}", ai.getName());
            if ((ai.isAgentWorkerOrService() || ai.isGraphicalConsole()) && ai.getAgentProperty(USE_REMOTE_COMMAND_DICTIONARY, "false").equals("true")) {
                List<AgentInfo> list = this.processingDictionaries;
                synchronized (list) {
                    if (this.processingDictionaries.contains(ai)) {
                        return msg;
                    }
                    this.processingDictionaries.add(ai);
                }
                this.topLevelAgent.getScheduler().schedule(() -> {
                    log.log(Level.FINE, "Command: Scheduling dict fetching for {0} ", new Object[]{ai.getName()});
                    StatusCommandDictionary statusMsg = this.bookkeeper.getCommandDictionaryForAgent(ai);
                    long start = System.currentTimeMillis();
                    HashMap dict = statusMsg.getDictionary();
                    long delta = System.currentTimeMillis() - start;
                    log.log(Level.FINE, "Command: Unzipping the dictionary for {0} took {1} ms.", new Object[]{ai.getName(), delta});
                    if (dict != null) {
                        this.bookkeeper.addCommandDictionary(ai, dict);
                    } else {
                        log.log(Level.FINE, "Command: Requesting data dictionary for agent {0}", ai.getName());
                        this.bookkeeper.getConcurrentMessagingUtils().sendAsynchronousCommand(new CommandRequest(ai.getName(), "publishAgentCommandDictionary"));
                    }
                }, 0L, TimeUnit.NANOSECONDS);
            }
        }
        return msg;
    }

    private class ClientSideAgentCommandDictionaryBookkeeper
    implements StatusMessageListener,
    AgentPresenceListener,
    AgentLockService.AgentLockUpdateListener {
        private final Map<String, byte[]> compressedDicts = new ConcurrentHashMap<String, byte[]>();

        private ClientSideAgentCommandDictionaryBookkeeper() {
        }

        protected void addCompressedDictionary(String dictionaryName, byte[] dict) {
            this.compressedDicts.put(dictionaryName, dict);
        }

        private StatusCommandDictionary getCommandDictionaryForAgent(AgentInfo ai) {
            String dictionaryName = AgentCommandDictionaryService.this.buildDataDictionaryName(ai);
            byte[] dict = this.compressedDicts.get(dictionaryName);
            if (dict != null) {
                log.log(Level.FINE, "Command: Dictionary already present for {0}", ai.getName());
            } else {
                long start = System.currentTimeMillis();
                try {
                    dict = AgentCommandDictionaryService.this.remoteDAO.getDictionary(dictionaryName);
                    this.addCompressedDictionary(dictionaryName, dict);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                long delta = System.currentTimeMillis() - start;
                log.log(Level.FINE, "Command: Fetching data dicionary from remote server for {0} took {1} ms", new Object[]{ai.getName(), delta});
            }
            if (dict != null) {
                StatusCommandDictionary msg = new StatusCommandDictionary(dict, "gzip");
                msg.setOriginAgentInfo(ai);
                return msg;
            }
            return null;
        }

        private ConcurrentMessagingUtils getConcurrentMessagingUtils() {
            if (AgentCommandDictionaryService.this.cmu == null) {
                AgentCommandDictionaryService.this.cmu = new ConcurrentMessagingUtils(AgentCommandDictionaryService.this.topLevelAgent.getMessagingAccess());
            }
            return AgentCommandDictionaryService.this.cmu;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnected(AgentInfo ... agents) {
            AgentCommandDictionaryService.this.dictionaryUpdateLock.lock();
            try {
                for (AgentInfo agent : agents) {
                    String agentName = agent.getName();
                    HashMap dict = (HashMap)AgentCommandDictionaryService.this.agentDictionaries.remove(agentName);
                    AgentCommandDictionaryService.this.agentInfos.remove(agentName);
                    if (dict == null) continue;
                    log.log(Level.FINER, "Removing dictionary for disconnecting agent {0}", new Object[]{agent.getName()});
                    AgentCommandDictionaryService.this.notifyAgentCommandDictionaryListeners(new AgentCommandDictionaryEvent(agent, AgentCommandDictionaryEvent.EventType.REMOVED, dict));
                }
            }
            finally {
                AgentCommandDictionaryService.this.dictionaryUpdateLock.unlock();
            }
        }

        public void onStatusMessage(StatusMessage msg) {
            if (AgentCommandDictionaryService.this.topLevelAgent.getName().equals(msg.getOriginAgentInfo().getName())) {
                return;
            }
            AgentInfo agentInfo = msg.getOriginAgentInfo();
            AgentCommandDictionaryService.this.dictionaryUpdateLock.lock();
            try {
                if (!AgentCommandDictionaryService.this.agentDictionaries.containsKey(agentInfo.getName())) {
                    this.addCommandDictionary(agentInfo, ((StatusCommandDictionary)msg).getDictionary());
                }
            }
            finally {
                AgentCommandDictionaryService.this.dictionaryUpdateLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addCommandDictionary(AgentInfo agent, HashMap<String, Dictionary> dictionary) {
            String agentName = agent.getName();
            AgentLock lock = AgentCommandDictionaryService.this.agentLockService.getLockForAgent(agentName);
            int dictionaryLevel = lock == null ? 0 : AgentCommandDictionaryService.this.agentLockService.getLevelForAgent(agentName);
            AgentCommandDictionaryService.this.dictionaryUpdateLock.lock();
            try {
                if (!AgentCommandDictionaryService.this.agentDictionaries.containsKey(agentName)) {
                    log.log(Level.FINER, "Received dictionary from {0}", agent.getName());
                    AgentCommandDictionaryService.this.agentDictionaries.put(agentName, dictionary);
                    AgentCommandDictionaryService.this.agentInfos.put(agentName, agent);
                    this.updateLockForDictionary(dictionary, lock);
                    if (lock != null) {
                        this.updateLevelForDictionary(dictionary, dictionaryLevel);
                    }
                    AgentCommandDictionaryService.this.notifyAgentCommandDictionaryListeners(new AgentCommandDictionaryEvent(agent, AgentCommandDictionaryEvent.EventType.ADDED, dictionary));
                    AgentCommandDictionaryService.this.processingDictionaries.remove(agent);
                }
            }
            finally {
                AgentCommandDictionaryService.this.dictionaryUpdateLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAgentHeldLockUpdate(String agentName, AgentLock lock) {
            AgentCommandDictionaryService.this.dictionaryUpdateLock.lock();
            try {
                HashMap dict = (HashMap)AgentCommandDictionaryService.this.agentDictionaries.get(agentName);
                if (dict != null) {
                    this.updateLockForDictionary(dict, lock);
                    log.log(Level.FINER, "Dictionary lock change for {0}", agentName);
                }
            }
            finally {
                AgentCommandDictionaryService.this.dictionaryUpdateLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAgentLevelChange(String agentName, int level) {
            AgentCommandDictionaryService.this.dictionaryUpdateLock.lock();
            try {
                HashMap dict = (HashMap)AgentCommandDictionaryService.this.agentDictionaries.get(agentName);
                if (dict != null) {
                    this.updateLevelForDictionary(dict, level);
                    log.log(Level.FINER, "Dictionary level change for {0}: new level {1}", new Object[]{agentName, level});
                }
            }
            finally {
                AgentCommandDictionaryService.this.dictionaryUpdateLock.unlock();
            }
        }

        private void updateLockForDictionary(HashMap<String, Dictionary> dict, AgentLock lock) {
            if (lock != null) {
                for (Dictionary d : dict.values()) {
                    d.setLevelForTypes(0, new Command.CommandType[0]);
                }
            } else {
                for (Dictionary d : dict.values()) {
                    d.setLevelForTypes(-1, new Command.CommandType[0]);
                    d.setLevelForTypes(0, new Command.CommandType[]{Command.CommandType.QUERY});
                }
            }
        }

        private void updateLevelForDictionary(HashMap<String, Dictionary> dict, int level) {
            for (Dictionary d : dict.values()) {
                d.setLevelForTypes(level, new Command.CommandType[0]);
            }
        }
    }

    private class AgentPublishDictionaryStrategy
    implements AgentPresenceListener {
        public boolean forcePublication = true;

        public AgentPublishDictionaryStrategy() {
            boolean bl = AgentCommandDictionaryService.this.remoteDAO != null ? !AgentCommandDictionaryService.this.remoteDAO.isDictionaryAvailable(AgentCommandDictionaryService.this.buildDataDictionaryName(AgentCommandDictionaryService.this.topLevelAgent.getAgentInfo())) : (this.forcePublication = true);
            if (this.forcePublication) {
                log.log(Level.INFO, "There will be forced publication of the Command Dictionary");
            }
        }

        public void connecting(AgentInfo ... agents) {
            this.publishOnConnectingAgents(agents);
        }

        private void publishOnConnectingAgents(AgentInfo ... agents) {
            for (AgentInfo a : agents) {
                if (!AgentCommandDictionaryService.isShellOrGraphicalConsole(a) || a.getAgentProperty(AgentCommandDictionaryService.USE_REMOTE_COMMAND_DICTIONARY, "false").equals("true") && !this.forcePublication) continue;
                log.log(Level.FINER, "Spontaneous publication for agent {0}", new Object[]{a.getName()});
                AgentCommandDictionaryService.this.publishAgentCommandDictionary();
                return;
            }
        }
    }

    public class AgentCommandDictionaryCommands {
        @Command(description="Get the agent's command dictionary", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public HashMap<String, Dictionary> getDictionaries() {
            return AgentCommandDictionaryService.this.getAgentCommandDictionary();
        }

        @Command(description="Get the list of command targets", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public List<String> getCommandTargets() {
            return new ArrayList<String>(AgentCommandDictionaryService.this.commandTargets);
        }

        @Command(description="Publish the agent's command dictionary on the status bus", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public void publishAgentCommandDictionary() {
            log.log(Level.FINER, "Received request to publish the command dictionary");
            AgentCommandDictionaryService.this.publishAgentCommandDictionary();
        }
    }

    public static class AgentCommandDictionaryEvent {
        private final EventType eventType;
        private final AgentInfo agentInfo;
        private final HashMap<String, Dictionary> dictionary;

        AgentCommandDictionaryEvent(AgentInfo agentInfo, EventType eventType, HashMap<String, Dictionary> dictionary) {
            this.eventType = eventType;
            this.agentInfo = agentInfo;
            this.dictionary = dictionary;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public AgentInfo getAgentInfo() {
            return this.agentInfo;
        }

        public HashMap<String, Dictionary> getDictionary() {
            return this.dictionary;
        }

        public static enum EventType {
            ADDED,
            UPDATED,
            REMOVED;

        }
    }

    public static interface AgentCommandDictionaryListener {
        public void commandDictionaryUpdate(AgentCommandDictionaryEvent var1);
    }
}

