/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.switches;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.common.switches.SwitchesOnOffCustomLevels;
import org.lsst.ccs.utilities.conv.TypeConversionException;

public class TestSwitchesCustomLevels {
    @Test
    public void testConversionToString() throws Exception {
        SwitchesOnOffCustomLevels customLevels = new SwitchesOnOffCustomLevels();
        customLevels.addSwitchCustomLevel("SW1", true, 3);
        customLevels.addSwitchCustomLevel("SW2", false, 2);
        customLevels.addSwitchCustomLevel("SW1", false, 3);
        customLevels.addSwitchCustomLevel("SW6", false, 22);
        Assert.assertEquals((Object)"[SW1-On:3, SW2-Off:2, SW1-Off:3, SW6-Off:22]", (Object)customLevels.toString());
    }

    @Test
    public void testConversionFromString() throws Exception {
        String customLevelsStr = "[SW1-On:4,SW23-Off:23, SW1-Off:43, SW66-Off:22,SW0-Off:0]";
        SwitchesOnOffCustomLevels customLevels = new SwitchesOnOffCustomLevels(customLevelsStr);
        Assert.assertNotNull((Object)customLevels.getCustomLevelForSwitchPosition("SW1", false));
        Assert.assertNotNull((Object)customLevels.getCustomLevelForSwitchPosition("SW1", true));
        Assert.assertNull((Object)customLevels.getCustomLevelForSwitchPosition("SW23", true));
        Assert.assertNotNull((Object)customLevels.getCustomLevelForSwitchPosition("SW23", false));
        Assert.assertNotNull((Object)customLevels.getCustomLevelForSwitchPosition("SW66", false));
        Assert.assertNotNull((Object)customLevels.getCustomLevelForSwitchPosition("SW0", false));
        Assert.assertEquals((long)4L, (long)customLevels.getCustomLevelForSwitchPosition("SW1", true).getCustomLevel());
        Assert.assertEquals((long)43L, (long)customLevels.getCustomLevelForSwitchPosition("SW1", false).getCustomLevel());
        Assert.assertEquals((long)23L, (long)customLevels.getCustomLevelForSwitchPosition("SW23", false).getCustomLevel());
        Assert.assertEquals((long)22L, (long)customLevels.getCustomLevelForSwitchPosition("SW66", false).getCustomLevel());
        Assert.assertEquals((long)0L, (long)customLevels.getCustomLevelForSwitchPosition("SW0", false).getCustomLevel());
    }

    @Test
    public void testDuplicateSwitchDefinition() throws Exception {
        String customLevelsStr = "[SW1-On:4,SW23-Off:23, SW1-On:43]";
        try {
            SwitchesOnOffCustomLevels customLevels = new SwitchesOnOffCustomLevels(customLevelsStr);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("SW1-On:4"));
        }
    }

    @Test
    public void testInvalidLevel() throws Exception {
        SwitchesOnOffCustomLevels customLevels;
        String customLevelsStr = "[SW1-On:4,SW23-Off:23.4]";
        try {
            customLevels = new SwitchesOnOffCustomLevels(customLevelsStr);
            Assert.assertTrue((boolean)false);
        }
        catch (TypeConversionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("SW23-Off:23.4"));
        }
        customLevelsStr = "[SW1-On:a,SW23-Off:23.4]";
        try {
            customLevels = new SwitchesOnOffCustomLevels(customLevelsStr);
            Assert.assertTrue((boolean)false);
        }
        catch (TypeConversionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("SW1-On:a"));
        }
    }

    @Test
    public void testSwitchPosition() throws Exception {
        String customLevelsStr = "[SW1-ON:4,SW23-Off:23]";
        try {
            SwitchesOnOffCustomLevels customLevels = new SwitchesOnOffCustomLevels(customLevelsStr);
            Assert.assertTrue((boolean)false);
        }
        catch (TypeConversionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("SW1-ON:4"));
        }
    }
}

