/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.common.ConfiguredAverageChannel;
import org.testng.Assert;

public class TestConfiguredAverageChannel
extends CcsTestCaseTemplate {
    @Test
    public void testDemoSubsystem() throws Exception {
        String pathName = "TestSubsystem";
        Subsystem s = BootUtils.getSubsystemFromFile((String)pathName);
        s.startAgent();
        ((AgentStateService)s.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 10L, TimeUnit.SECONDS);
        ConfiguredAverageChannel averageChannel = (ConfiguredAverageChannel)s.getComponentLookup().getComponentByPath("average");
        Assert.assertNotNull((Object)averageChannel);
        Assert.assertEquals((int)2, (int)averageChannel.getChannels().size());
        Assert.assertEquals((int)2, (int)averageChannel.getWeights().size());
        Assert.assertEquals((String)"0/OtherDevice/CryoVac", (String)((Channel)averageChannel.getChannels().get(0)).getPath());
        Assert.assertEquals((String)"0/IonPumps/CIP2_I", (String)((Channel)averageChannel.getChannels().get(1)).getPath());
        Assert.assertEquals((double)1.0, (Double)((Double)averageChannel.getWeights().get(0)));
        Assert.assertEquals((double)2.0, (Double)((Double)averageChannel.getWeights().get(1)));
        ConfigurationService configService = (ConfigurationService)s.getAgentService(ConfigurationService.class);
        ComponentConfigurationEnvironment config = configService.getComponentConfigurationEnvironment("average");
        ArrayList<String> chanNames = new ArrayList<String>();
        ArrayList<Double> chanWeights = new ArrayList<Double>();
        chanNames.add(".*");
        try {
            config.submitChange("chanNames", chanNames);
            config.submitChange("chanWeights", chanWeights);
            config.commitSubmittedChangesForComponent();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("chanWeights and chanNames do not have same size"), (String)e.getMessage());
        }
        chanNames.clear();
        chanNames.add("{\"user_id\" : [0-9]*}");
        chanWeights.clear();
        chanWeights.add(0.9);
        try {
            config.submitChange("chanNames", chanNames);
            config.submitChange("chanWeights", chanWeights);
            config.commitSubmittedChangesForComponent();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not a valid regular expression"), (String)e.getMessage());
        }
        chanNames.clear();
        chanNames.add(".*");
        chanWeights.clear();
        chanWeights.add(-0.9);
        try {
            config.submitChange("chanNames", chanNames);
            config.submitChange("chanWeights", chanWeights);
            config.commitSubmittedChangesForComponent();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not positive-definite"), (String)e.getMessage());
        }
        chanNames.clear();
        chanNames.add(".*something.*");
        chanWeights.clear();
        chanWeights.add(2.0);
        try {
            config.submitChange("chanNames", chanNames);
            config.submitChange("chanWeights", chanWeights);
            config.commitSubmittedChangesForComponent();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("didn't match any available channels"), (String)e.getMessage());
        }
        chanNames.clear();
        chanNames.add(".*IonPumps.*");
        chanNames.add(".*CIP6_V");
        chanWeights.clear();
        chanWeights.add(2.0);
        chanWeights.add(1.0);
        try {
            config.submitChange("chanNames", chanNames);
            config.submitChange("chanWeights", chanWeights);
            config.commitSubmittedChangesForComponent();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("IonPumps/CIP6_V has already been selected by another entry in \"channelNames\" .*CIP6_V"), (String)e.getMessage());
        }
        chanNames.clear();
        chanNames.add(".*Vac");
        chanNames.add(".*IonPumps.*");
        chanWeights.clear();
        chanWeights.add(1.0);
        chanWeights.add(2.0);
        try {
            config.submitChange("chanNames", chanNames);
            config.submitChange("chanWeights", chanWeights);
            config.commitSubmittedChangesForComponent();
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertEquals((int)14, (int)averageChannel.getChannels().size());
        Assert.assertEquals((double)26.0, (double)averageChannel.getSumOfWeights());
        s.shutdownAgent();
    }
}

