/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public final class SortAndSlice {
    static final SortAndSlice noSort = new SortAndSlice();
    static final int[] defaultLimits = new int[]{0, Integer.MAX_VALUE, Integer.MAX_VALUE};
    public int[] sortOrder;
    public boolean[] sortDescending;
    public boolean[] sortNullsLast;
    public Collation[] collations;
    boolean sortUnion;
    HsqlArrayList exprList = new HsqlArrayList();
    ExpressionOp limitCondition;
    int columnCount;
    boolean hasNullsLast;
    boolean strictLimit;
    boolean zeroLimit;
    boolean usingIndex;
    boolean allDescending;
    public boolean skipSort = false;
    public boolean skipFullResult = false;
    public Index index;
    public Table primaryTable;
    public Index primaryTableIndex;
    public int[] colIndexes;
    public boolean isGenerated;

    public HsqlArrayList getExpressionList() {
        return this.exprList;
    }

    public boolean hasOrder() {
        return this.exprList.size() != 0;
    }

    public boolean hasLimit() {
        return this.limitCondition != null;
    }

    public int getOrderLength() {
        return this.exprList.size();
    }

    public void addOrderExpression(Expression expression) {
        this.exprList.add(expression);
    }

    public void addLimitCondition(ExpressionOp expressionOp) {
        this.limitCondition = expressionOp;
    }

    public void setStrictLimit() {
        this.strictLimit = true;
    }

    public void setZeroLimit() {
        this.zeroLimit = true;
    }

    public void setUsingIndex() {
        this.usingIndex = true;
    }

    public void prepareSingleColumn(int n) {
        this.sortOrder = new int[1];
        this.sortDescending = new boolean[1];
        this.sortNullsLast = new boolean[1];
        this.sortOrder[0] = n;
    }

    public void prepareMultiColumn(int n) {
        this.sortOrder = new int[n];
        this.sortDescending = new boolean[n];
        this.sortNullsLast = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.sortOrder[i] = i;
        }
    }

    public void prepare(int n) {
        this.columnCount = this.exprList.size();
        if (this.columnCount == 0) {
            return;
        }
        this.sortOrder = new int[this.columnCount + n];
        this.sortDescending = new boolean[this.columnCount + n];
        this.sortNullsLast = new boolean[this.columnCount + n];
        ArrayUtil.fillSequence(this.sortOrder);
        for (int i = 0; i < this.columnCount; ++i) {
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)this.exprList.get(i);
            this.sortDescending[i] = expressionOrderBy.isDescending();
            this.sortNullsLast[i] = expressionOrderBy.isNullsLast();
            this.hasNullsLast |= this.sortNullsLast[i];
        }
    }

    public void prepare(QuerySpecification querySpecification) {
        this.columnCount = this.exprList.size();
        if (this.columnCount == 0) {
            return;
        }
        this.sortOrder = new int[this.columnCount];
        this.sortDescending = new boolean[this.columnCount];
        this.sortNullsLast = new boolean[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)this.exprList.get(i);
            this.sortOrder[i] = expressionOrderBy.getLeftNode().queryTableColumnIndex == -1 ? querySpecification.indexStartOrderBy + i : expressionOrderBy.getLeftNode().queryTableColumnIndex;
            this.sortDescending[i] = expressionOrderBy.isDescending();
            this.sortNullsLast[i] = expressionOrderBy.isNullsLast();
            this.hasNullsLast |= this.sortNullsLast[i];
            if (expressionOrderBy.collation == null) continue;
            if (this.collations == null) {
                this.collations = new Collation[this.columnCount];
            }
            this.collations[i] = expressionOrderBy.collation;
        }
    }

    void setSortIndex(QuerySpecification querySpecification) {
        int n;
        Cloneable cloneable;
        int n2;
        if (this == noSort) {
            return;
        }
        if (this.isGenerated) {
            return;
        }
        for (n2 = 0; n2 < this.columnCount; ++n2) {
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)this.exprList.get(n2);
            cloneable = expressionOrderBy.getLeftNode().getDataType();
            if (!((Type)cloneable).isArrayType() && !((Type)cloneable).isLobType()) continue;
            throw Error.error(5534);
        }
        if (querySpecification == null) {
            return;
        }
        if ((querySpecification.isDistinctSelect || querySpecification.isGrouped || querySpecification.isAggregated) && !querySpecification.isSimpleDistinct) {
            return;
        }
        if (this.columnCount == 0) {
            if (this.limitCondition == null) {
                return;
            }
            this.skipFullResult = true;
            return;
        }
        if (this.collations != null) {
            return;
        }
        this.colIndexes = new int[this.columnCount];
        n2 = 0;
        for (n = 0; n < this.columnCount; ++n) {
            cloneable = ((Expression)this.exprList.get(n)).getLeftNode();
            if (((Expression)cloneable).getType() != 2) {
                return;
            }
            if (((ExpressionColumn)cloneable).getRangeVariable() != querySpecification.rangeVariables[0]) {
                return;
            }
            this.colIndexes[n] = ((Expression)cloneable).columnIndex;
            if (((Expression)cloneable).getColumn().getNullability() == 0) continue;
            n2 = 1;
        }
        if (this.hasNullsLast && n2 != 0) {
            return;
        }
        n = ArrayUtil.countTrueElements(this.sortDescending);
        boolean bl = this.allDescending = n == this.columnCount;
        if (!this.allDescending && n > 0) {
            return;
        }
        this.primaryTable = querySpecification.rangeVariables[0].getTable();
        this.primaryTableIndex = this.primaryTable.getFullIndexForColumns(this.colIndexes);
    }

    void setSortRange(QuerySpecification querySpecification) {
        Index index;
        if (this == noSort) {
            return;
        }
        if (this.primaryTableIndex == null) {
            if (querySpecification.isSimpleDistinct) {
                this.setSortIndex(querySpecification);
            }
            if (this.primaryTableIndex == null) {
                return;
            }
        }
        if ((index = querySpecification.rangeVariables[0].getSortIndex()) == null) {
            return;
        }
        if (this.primaryTable != querySpecification.rangeVariables[0].rangeTable) {
            return;
        }
        if (index == this.primaryTableIndex) {
            boolean bl;
            if (this.allDescending && !(bl = querySpecification.rangeVariables[0].reverseOrder())) {
                return;
            }
            this.skipSort = true;
            this.skipFullResult = true;
        } else if (!querySpecification.rangeVariables[0].joinConditions[0].hasIndexCondition() && querySpecification.rangeVariables[0].setSortIndex(this.primaryTableIndex, this.allDescending)) {
            this.skipSort = true;
            this.skipFullResult = true;
        }
    }

    public boolean prepareSpecial(Session session, QuerySpecification querySpecification) {
        Expression expression = querySpecification.exprColumns[querySpecification.indexStartAggregates];
        int n = expression.getType();
        if ((expression = expression.getLeftNode()).getType() != 2) {
            return false;
        }
        if (((ExpressionColumn)expression).getRangeVariable() != querySpecification.rangeVariables[0]) {
            return false;
        }
        Index index = querySpecification.rangeVariables[0].getSortIndex();
        if (index == null) {
            return false;
        }
        if (querySpecification.rangeVariables[0].hasSingleIndexCondition()) {
            int[] nArray = index.getColumns();
            if (nArray[0] != ((ExpressionColumn)expression).getColumnIndex()) {
                return false;
            }
            if (n == 74) {
                querySpecification.rangeVariables[0].reverseOrder();
            }
        } else {
            if (querySpecification.rangeVariables[0].hasAnyIndexCondition()) {
                return false;
            }
            Table table = querySpecification.rangeVariables[0].getTable();
            Index index2 = table.getIndexForColumn(session, ((ExpressionColumn)expression).getColumnIndex());
            if (index2 == null) {
                return false;
            }
            Expression[] expressionArray = new Expression[]{ExpressionLogical.newNotNullCondition(expression)};
            querySpecification.rangeVariables[0].joinConditions[0].addIndexCondition(expressionArray, index2, 1);
            if (n == 74) {
                querySpecification.rangeVariables[0].reverseOrder();
            }
        }
        this.columnCount = 1;
        this.sortOrder = new int[this.columnCount];
        this.sortDescending = new boolean[this.columnCount];
        this.sortNullsLast = new boolean[this.columnCount];
        this.skipSort = true;
        this.skipFullResult = true;
        return true;
    }

    int[] getLimits(Session session, QueryExpression queryExpression, int n) {
        if (this == noSort && n == 0) {
            return defaultLimits;
        }
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        boolean bl = false;
        if (this.hasLimit()) {
            Integer n5 = (Integer)this.limitCondition.getLeftNode().getValue(session);
            if (n5 == null || n5 < 0) {
                throw Error.error(3453);
            }
            n2 = n5;
            boolean bl2 = bl = n2 != 0;
            if (this.limitCondition.getRightNode() != null) {
                n5 = (Integer)this.limitCondition.getRightNode().getValue(session);
                if (n5 == null || n5 < 0 || this.strictLimit && n5 == 0) {
                    throw Error.error(3452);
                }
                if (n5 == 0 && !this.zeroLimit) {
                    n3 = Integer.MAX_VALUE;
                } else {
                    n3 = n5;
                    bl = true;
                }
            }
        }
        if (n != 0) {
            if (n < n3) {
                n3 = n;
            }
            bl = true;
        }
        boolean bl3 = false;
        if (queryExpression instanceof QuerySpecification) {
            QuerySpecification querySpecification = (QuerySpecification)queryExpression;
            if (!querySpecification.isDistinctSelect && !querySpecification.isGrouped) {
                bl3 = true;
            }
            if (querySpecification.isSimpleDistinct) {
                bl3 = true;
            }
        }
        if (bl) {
            if (!(!bl3 || this.hasOrder() && !this.skipSort || this.hasLimit() && !this.skipFullResult || n4 - n2 <= n3)) {
                n4 = n2 + n3;
            }
            return new int[]{n2, n3, n4};
        }
        return defaultLimits;
    }

    public void setIndex(Session session, TableBase tableBase) {
        this.index = this.getNewIndex(session, tableBase);
    }

    public Index getNewIndex(Session session, TableBase tableBase) {
        if (this.hasOrder()) {
            Index index = tableBase.createAndAddIndexStructure(session, null, this.sortOrder, this.sortDescending, this.sortNullsLast, false, false, false);
            if (this.collations != null) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.collations[i] == null) continue;
                    Type type = index.getColumnTypes()[i];
                    index.getColumnTypes()[i] = type = Type.getType(type.typeCode, type.getCharacterSet(), this.collations[i], type.precision, type.scale);
                }
            }
            return index;
        }
        return null;
    }
}

