/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.security.InvalidParameterException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.data.MonitorTask;

public class MonitorTaskControl
implements HasLifecycle {
    private static final String MON_UPDATE_TASK = "monitor-update";
    private static final String MON_PUBLISH_TASK = "monitor-publish";
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    private final Map<String, MonitorTask> monitorTaskMap = new LinkedHashMap<String, MonitorTask>();
    private boolean periodChanged = false;

    public static MonitorTaskControl createNode(Subsystem subsys, String name) {
        ComponentLookup lookupService = subsys.getComponentLookup();
        ComponentNode topNode = lookupService.getComponentNodeForObject((Object)subsys);
        MonitorTaskControl control = new MonitorTaskControl();
        ComponentNode controlNode = new ComponentNode(name, (Object)control);
        lookupService.addComponentNodeToLookup(topNode, controlNode);
        return control;
    }

    public void postInit() {
        List allTasks = this.periodicTaskService.getAgentPeriodicTaskNames();
        TreeSet<String> monTasks = new TreeSet<String>();
        for (String taskPath : allTasks) {
            if (!taskPath.startsWith("monitor-update/")) continue;
            monTasks.add(taskPath.substring(taskPath.indexOf(47) + 1));
        }
        int index = 0;
        for (String taskName : monTasks) {
            this.monitorTaskMap.put(taskName, new MonitorTask(taskName, index++, this.getTaskUpdatePeriod(taskName)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set the monitor publish period")
    public synchronized void setPublishPeriod(@Argument(description="The publish period (ms)") int period) {
        this.periodicTaskService.setPeriodicTaskPeriod(MON_PUBLISH_TASK, Duration.ofMillis(period));
        Iterator<MonitorTask> iterator = this.monitorTaskMap.values().iterator();
        while (iterator.hasNext()) {
            MonitorTask task;
            MonitorTask monitorTask = task = iterator.next();
            synchronized (monitorTask) {
                if (!task.isActive()) {
                    this.setTaskPublishPeriod(task.getName(), period);
                }
            }
        }
        this.periodChanged = true;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the special monitor task names")
    public List<String> getTaskNames() {
        ArrayList<String> monTasks = new ArrayList<String>();
        monTasks.addAll(this.monitorTaskMap.keySet());
        return monTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set the period for a special monitor task")
    public void setTaskPeriod(@Argument(description="The task name") String taskName, @Argument(description="The task period (ms)") int period) {
        MonitorTask task;
        MonitorTask monitorTask = task = this.getTask(taskName);
        synchronized (monitorTask) {
            task.setPeriod(period);
            if (task.isActive()) {
                this.setTaskUpdatePeriod(taskName, period);
                this.setTaskPublishPeriod(taskName, period);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set the active state for a special monitor task")
    public void setTaskActive(@Argument(description="The task name") String taskName, @Argument(description="Whether to make active") boolean active) {
        MonitorTask task;
        MonitorTask monitorTask = task = this.getTask(taskName);
        synchronized (monitorTask) {
            task.setActive(active);
            if (active) {
                int period = task.getPeriod();
                this.setTaskUpdatePeriod(taskName, period);
                this.setTaskPublishPeriod(taskName, period);
            } else {
                this.setTaskUpdatePeriod(taskName, this.getUpdatePeriod());
                this.setTaskPublishPeriod(taskName, this.getPublishPeriod());
            }
        }
    }

    public synchronized boolean hasPeriodChanged() {
        boolean changed = this.periodChanged;
        this.periodChanged = false;
        return changed;
    }

    public Map<String, MonitorTask> getMonitorTaskMap() {
        return this.monitorTaskMap;
    }

    public int getPublishPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod(MON_PUBLISH_TASK).toMillis();
    }

    private int getUpdatePeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod(MON_UPDATE_TASK).toMillis();
    }

    private int getTaskUpdatePeriod(String taskName) {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-update/" + taskName).toMillis();
    }

    private void setTaskUpdatePeriod(String taskName, int period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-update/" + taskName, Duration.ofMillis(period));
    }

    private void setTaskPublishPeriod(String taskName, int period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish/" + taskName, Duration.ofMillis(period));
    }

    private MonitorTask getTask(String taskName) {
        MonitorTask task = this.monitorTaskMap.get(taskName);
        if (task == null) {
            throw new InvalidParameterException("Unknown monitor task name: " + taskName);
        }
        return task;
    }
}

