package org.lsst.ccs.subsystem.common.devices.refrigeration;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 *  Defines a AMETek Cryo Device.
 *
 *  @author Homer Neal
 */
interface CryoTelDevice {

    void initDevice();
    void reconnect();
    String getProduct() throws DriverException;
    String getVersion() throws DriverException;
    String getMode() throws DriverException;
    double getSetPoint() throws DriverException;
    double getTemperature() throws DriverException;
    double getPower() throws DriverException;
    void   setMode(String mode) throws DriverException;
    void   setSetPoint(double temp) throws DriverException;
    void   setPower(double pwr) throws DriverException;
    void   setState(int istate);
    int    getState();
        
    
}
