package org.lsst.ccs.subsystem.common;

import java.util.logging.Logger;
import java.util.logging.Level;

/**
 * Configuration and channel error reporting routines.
 * 
 * @author saxton
 */
public class ErrorUtils {

    /**
     *  Reports configuration error and terminates - use during initialization.
     * 
     *  @param  logger  The logger to use
     *  @param  name    The entity name
     *  @param  param   The parameter name
     *  @param  desc    The error description
     *  
     */
    public static void reportConfigError(Logger logger, String name, String param, String desc)
    {
        logger.log(Level.SEVERE, "{0} configuration parameter {1} {2}", new Object[]{name, param, desc});
        throw new RuntimeException("Fatal configuration error");
    }


    /**
     *  Reports channel parameter error - use only from checkChannel.
     * 
     *  @param  logger  The logger to use
     *  @param  name    The channel name
     *  @param  param   The parameter name
     *  @param  value   The parameter value
     *  @throws  Exception  Always
     */
    public static void reportChannelError(Logger logger, String name, String param, Object value) throws Exception
    {
        logger.log(Level.SEVERE, "Invalid {0} value ({1}) for {2} channel", new Object[]{param, value, name});
        throw new Exception("Invalid channel parameter");
    }
    
}
