/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePulse;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.common.devices.Maq20Device;
import org.lsst.ccs.utilities.logging.Logger;

public class Maq20PulseControl
extends Control
implements Maq20Device.Maq20DiscControl {
    private String type;
    @ConfigurationParameter
    private int pulsesPerRevn = 1;
    private static final Logger LOG = Logger.getLogger((String)Maq20PulseControl.class.getName());
    private Maq20Device.ModuleData modData;
    private Maq20DiscretePulse pulse;
    private int funcNum;
    private boolean inited = false;

    protected void configure(Monitor mon, Device devc) {
        String[] words;
        super.configure(mon, devc);
        if (this.type == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"type", (String)"not specified");
        }
        if ((words = this.type.split(":")).length != 2) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"type", (String)"doesn't have exactly two elements");
        }
        try {
            int modIx = Integer.decode(words[0]);
            this.modData = ((Maq20Device)devc).getModuleData(modIx);
            if (this.modData == null) {
                MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"module", (String)"doesn't exist");
            }
        }
        catch (NumberFormatException ex) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"module index", (String)"is not numeric");
        }
        if (!words[1].equals("0") && !words[1].equals("1")) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"function number", (String)"is not 0 or 1");
        }
        this.funcNum = Integer.decode(words[1]);
    }

    @Override
    public void initialize() throws DriverException {
        this.pulse = this.modData.maqDiscPulse;
        this.inited = true;
        this.checkPulse();
        this.pulse.enable(this.funcNum);
        this.setPulsesPerRevn(this.pulsesPerRevn);
    }

    @ConfigurationParameterChanger
    public void setPulsesPerRevn(int pulses) throws DriverException {
        this.pulsesPerRevn = pulses;
        if (this.inited) {
            this.checkPulse();
            this.pulse.setPulsesPerRevn(this.funcNum, this.pulsesPerRevn);
            this.pulse.armFunction(this.funcNum);
        }
    }

    @Command(description="Get number of pulses per revolution")
    public int getPulsesPerRevn() {
        return this.pulsesPerRevn;
    }

    private void checkPulse() throws DriverException {
        if (this.pulse == null) {
            throw new DriverException("Cannot access pulse function");
        }
    }
}

