/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.focalplane;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.BasicChannel;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystem.common.ui.focalplane.Segment;

public class SegmentTest
extends CcsTestCaseTemplate {
    @Test
    public void testGetIndices_String() {
        Assert.assertArrayEquals((int[])new int[]{2, 1, 1, 2, 0, 1}, (int[])Segment.getIndices((String)"agent//R21/Reb1/S12//Seg01//group1//group2"));
        Assert.assertArrayEquals((int[])new int[]{2, 2, 2, 1, -1, -1}, (int[])Segment.getIndices((String)"age-nt/R22/Reb2/S21///group"));
        Assert.assertArrayEquals((int[])new int[]{2, 3, -1, -1, -1, -1}, (int[])Segment.getIndices((String)"R23/group"));
        Assert.assertArrayEquals(null, (int[])Segment.getIndices((String)"Reb1/group"));
        Assert.assertArrayEquals(null, (int[])Segment.getIndices((String)"R35/group"));
        Assert.assertArrayEquals((int[])new int[]{2, 3, 1, 2, -1, -1}, (int[])Segment.getIndices((String)"R23/Reb1/S12"));
        Assert.assertArrayEquals((int[])new int[]{0, 0, 0, 1, -1, -1}, (int[])Segment.getIndices((String)"R00/RebW/SW1"));
        Assert.assertArrayEquals((int[])new int[]{0, 0, 0, 1, -1, -1}, (int[])Segment.getIndices((String)"R00/RebW/SW"));
        Assert.assertArrayEquals((int[])new int[]{0, 4, 1, 1, -1, -1}, (int[])Segment.getIndices((String)"R04/RebG/SG1"));
        Assert.assertArrayEquals((int[])new int[]{0, 4, 1, -1, -1, -1}, (int[])Segment.getIndices((String)"agent/R04/RebG/SG"));
    }

    @Test
    public void testGetPathPrefix_intArr() {
        Assert.assertEquals((Object)"", (Object)Segment.getPathPrefix((int[])null));
        Assert.assertEquals((Object)"", (Object)Segment.getPathPrefix((int[])new int[]{-1, -1, -1, -1, -1, -1}));
        Assert.assertEquals((Object)"R23/", (Object)Segment.getPathPrefix((int[])new int[]{2, 3, -1, -1, -1, -1}));
        Assert.assertEquals((Object)"R23/Reb2/", (Object)Segment.getPathPrefix((int[])new int[]{2, 3, 2, -1, -1, -1}));
        Assert.assertEquals((Object)"R23/Reb2/S20/", (Object)Segment.getPathPrefix((int[])new int[]{2, 3, 2, 0, -1, -1}));
        Assert.assertEquals((Object)"R23/Reb2/S20/Seg01/", (Object)Segment.getPathPrefix((int[])new int[]{2, 3, 2, 0, 0, 1}));
        Assert.assertEquals((Object)"R00/RebW/SW/", (Object)Segment.getPathPrefix((int[])new int[]{0, 0, 0, 1, -1, -1}));
        Assert.assertEquals((Object)"R04/RebG/SG1/", (Object)Segment.getPathPrefix((int[])new int[]{0, 4, 1, 1, -1, -1}));
        Assert.assertEquals((Object)"R04/RebG/", (Object)Segment.getPathPrefix((int[])new int[]{0, 4, 1, -1, -1, -1}));
    }

    @Test
    public void testGetPathPrefix_AgentChannel() {
        AgentInfo agent = new AgentInfo("agent-name", AgentInfo.AgentType.WORKER);
        BasicChannel ch = new BasicChannel("agent-name/R12/group", agent, null, null);
        Assert.assertEquals((Object)"R12/", (Object)Segment.getPathPrefix((AgentChannel)ch));
        Assert.assertEquals((Object)"R12/", (Object)Segment.getPathPrefix((AgentChannel)ch));
        Assert.assertEquals((Object)"R12/", (Object)Segment.getPathPrefix((AgentChannel)ch));
    }

    @Test
    public void testGetPathPrefix_String() {
        Assert.assertEquals((Object)"R22/Reb2/S21/", (Object)Segment.getPathPrefix((String)"age-nt/R22/Reb2/S21///group"));
        Assert.assertEquals((Object)"R23/", (Object)Segment.getPathPrefix((String)"R23/group"));
        Assert.assertEquals((Object)"", (Object)Segment.getPathPrefix((String)"Reb1/group"));
        Assert.assertEquals((Object)"", (Object)Segment.getPathPrefix((String)"R35/group"));
        Assert.assertEquals((Object)"R00/RebW/SW/", (Object)Segment.getPathPrefix((String)"R00/RebW/SW1"));
        Assert.assertEquals((Object)"R00/RebW/SW/", (Object)Segment.getPathPrefix((String)"agent/R00/RebW/SW"));
    }

    @Test
    public void testStripPathPrefix() {
        Assert.assertEquals((Object)"agent/group1//group2", (Object)Segment.stripPathPrefix((String)"agent//R21/Reb1/S12//Seg01//group1//group2"));
        Assert.assertEquals((Object)"age-nt/group", (Object)Segment.stripPathPrefix((String)"age-nt/R22/Reb2/S21///group"));
        Assert.assertEquals((Object)"group", (Object)Segment.stripPathPrefix((String)"R23/group"));
        Assert.assertEquals((Object)"Reb1/group", (Object)Segment.stripPathPrefix((String)"Reb1/group"));
        Assert.assertEquals((Object)"R35/group", (Object)Segment.stripPathPrefix((String)"R35/group"));
        Assert.assertEquals((Object)"agent/Seg00/group", (Object)Segment.stripPathPrefix((String)"agent/R44/Seg00/group"));
        Assert.assertEquals((Object)"agent/group", (Object)Segment.stripPathPrefix((String)"agent/R44/RebW/SW/group"));
        Assert.assertEquals((Object)"agent/group", (Object)Segment.stripPathPrefix((String)"agent/R44/RebW/SW1/group"));
    }
}

