/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.TokenizedCommand;

class DefaultDictionaryCompleter
implements DictionaryCompleter,
Serializable {
    private static final long serialVersionUID = 8413764867907456999L;
    private final Dictionary dict;

    public DefaultDictionaryCompleter(Dictionary dict) {
        this.dict = dict;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int complete(String buffer, int index, List<CharSequence> list) {
        TreeSet<Object> set;
        boolean isCompletingOption;
        boolean endsWithWhiteSpace;
        TokenizedCommand tc = new TokenizedCommand(buffer.substring(0, index));
        int argCount = tc.getArgumentCount();
        boolean bl = endsWithWhiteSpace = !tc.isEmpty() && Character.isWhitespace(buffer.charAt(index - 1));
        if (endsWithWhiteSpace) {
            ++argCount;
        }
        if (this.dict == null) {
            return index;
        }
        boolean bl2 = isCompletingOption = tc.getLastToken() != null && tc.getLastToken().isOption();
        if (isCompletingOption) {
            boolean isShortOption = tc.getLastToken().isShortOption();
            String startOpt = tc.getLastToken().getString();
            ArrayList<List<SupportedOption>> supportedOptions = new ArrayList<List<SupportedOption>>();
            String commandName = tc.getCommand();
            for (DictionaryCommand dictionaryCommand : this.dict.filterByVisibilityIterator()) {
                String command = dictionaryCommand.getCommandName();
                if (!command.equals(commandName) || !dictionaryCommand.hasOptions() || dictionaryCommand.getArguments().length < argCount && !dictionaryCommand.isVarArgs()) continue;
                supportedOptions.add(dictionaryCommand.getSupportedOptions());
            }
            if (supportedOptions.size() == 1) {
                List opts = (List)supportedOptions.get(0);
                for (SupportedOption opt : opts) {
                    if (isShortOption) {
                        if (tc.getOptions().hasOption(opt)) continue;
                        list.add(opt.getSingleLetterName() + " ");
                        continue;
                    }
                    if (!startOpt.isEmpty() && opt.getName().startsWith(startOpt)) {
                        list.add(opt.getName() + " ");
                        continue;
                    }
                    if (!startOpt.isEmpty() || tc.getOptions().hasOption(opt)) continue;
                    list.add(opt.getName() + " ");
                }
            }
            if (isShortOption) {
                return index;
            }
            return tc.getLastToken().getLocation();
        }
        if (tc.isEmpty()) {
            set = new TreeSet<Object>();
            for (DictionaryCommand def : this.dict.filterByVisibilityIterator()) {
                Object command = def.getCommandName();
                command = (String)command + " ";
                set.add(command);
                for (String string : def.getAliases()) {
                    String string2 = string + " ";
                    set.add(string2);
                }
            }
        } else {
            if (argCount == 0) {
                String prefix = tc.getCommand();
                TreeSet<CallSite> set2 = new TreeSet<CallSite>();
                HashSet<DictionaryCommand> uniqueCommands = new HashSet<DictionaryCommand>();
                for (DictionaryCommand def : this.dict.filterByVisibilityIterator()) {
                    String string = def.getCommandName();
                    if (string.startsWith(prefix)) {
                        String string3 = string + " ";
                        set2.add((CallSite)((Object)string3));
                        uniqueCommands.add(def);
                    }
                    for (String string4 : def.getAliases()) {
                        if (!string4.startsWith(prefix)) continue;
                        String string5 = string4 + " ";
                        set2.add((CallSite)((Object)string5));
                        uniqueCommands.add(def);
                    }
                }
                if (set2.size() > 1 && uniqueCommands.size() == 1) {
                    list.add(((DictionaryCommand)uniqueCommands.iterator().next()).getCommandName() + " ");
                } else {
                    list.addAll(set2);
                }
                return tc.getCommandLocation();
            }
            String command = tc.getCommand();
            String lastArg = endsWithWhiteSpace ? "" : tc.getArgument(argCount - 1);
            ArrayList<CallSite> defaultCompletions = new ArrayList<CallSite>();
            boolean useDefaultCompletions = true;
            for (DictionaryCommand dictionaryCommand : this.dict.filterByVisibilityIterator()) {
                void var17_51;
                if (!dictionaryCommand.matchesCommandOrAlias(command) || dictionaryCommand.getArguments().length < argCount && !dictionaryCommand.isVarArgs()) continue;
                int currentArgIndex = Math.min(argCount, dictionaryCommand.getArguments().length) - 1;
                DictionaryArgument dictionaryArgument = dictionaryCommand.getArguments()[currentArgIndex];
                boolean skipCurrentCommand = false;
                int n = currentArgIndex - 1;
                while (var17_51 >= 0) {
                    DictionaryArgument previousArg = dictionaryCommand.getArguments()[var17_51];
                    if (previousArg.getAllowedValues().size() > 0 && !previousArg.getAllowedValues().contains(tc.getArgument((int)var17_51))) {
                        skipCurrentCommand = true;
                    }
                    --var17_51;
                }
                if (skipCurrentCommand) continue;
                List<String> list2 = dictionaryArgument.getAllowedValues();
                if (list2.isEmpty()) {
                    String helpStr = "# " + dictionaryArgument.getName() + " " + dictionaryArgument.getSimpleType() + " " + dictionaryArgument.getDescription();
                    if (defaultCompletions.contains(helpStr)) continue;
                    defaultCompletions.add((CallSite)((Object)helpStr));
                    continue;
                }
                useDefaultCompletions = false;
                for (String string : list2) {
                    String string6;
                    if (!DefaultDictionaryCompleter.startsWithIgnoreCase(string, lastArg) || list.contains(string6 = string + " ")) continue;
                    list.add(string6);
                }
            }
            if (useDefaultCompletions) {
                for (String string : defaultCompletions) {
                    list.add(string);
                }
            }
            return endsWithWhiteSpace ? index : tc.getArgumentLocation(argCount - 1);
        }
        list.addAll(set);
        return index;
    }

    private static boolean startsWithIgnoreCase(String reference, String test) {
        if (test.length() > reference.length()) {
            return false;
        }
        return reference.substring(0, test.length()).equalsIgnoreCase(test);
    }
}

