/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida.adapter;

import hep.aida.IBaseHistogram;
import hep.aida.ICloud;
import hep.aida.IHistogram;
import hep.aida.IManagedObject;
import hep.aida.IProfile;
import hep.aida.ref.tree.Tree;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extension.aida.AIDAPlugin;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.images.ImageHandler;

public class HistogramAdapter
extends DefaultFTreeNodeAdapter {
    public static final Icon histogramIcon = ImageHandler.getIcon((String)"images/Histogram.gif", AIDAPlugin.class);
    public static final Icon cloudIcon = ImageHandler.getIcon((String)"images/Cloud.gif", AIDAPlugin.class);
    private Studio app;
    private AIDAPlugin thePlugin;
    private Commands commands = new Commands();

    public HistogramAdapter(AIDAPlugin thePlugin, Studio app) {
        super(100);
        this.app = app;
        this.thePlugin = thePlugin;
    }

    public Icon icon(FTreeNode node, Icon oldIcon, boolean selected, boolean expanded) {
        Class nodeType = node.type();
        if (IHistogram.class.isAssignableFrom(nodeType)) {
            return histogramIcon;
        }
        if (ICloud.class.isAssignableFrom(nodeType)) {
            return cloudIcon;
        }
        if (IProfile.class.isAssignableFrom(nodeType)) {
            return histogramIcon;
        }
        return null;
    }

    public JPopupMenu modifyPopupMenu(FTreeNode[] nodes, JPopupMenu menu) {
        this.commands.setSelectedNodes(nodes);
        if (menu.getSubElements().length != 0) {
            menu.addSeparator();
        }
        JMenuItem item = new JMenuItem("Show");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Overlay on Current Plot");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Add to Current Plot");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Show in New Plot");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Show on New Page");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Clear");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Delete");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        return menu;
    }

    public CommandProcessor commandProcessor(FTreeNode[] selectedNodes) {
        this.commands.setSelectedNodes(selectedNodes);
        return this.commands;
    }

    public boolean doubleClick(FTreeNode node) {
        this.commands.setSelectedNodes(new FTreeNode[]{node});
        this.commands.onShow();
        return true;
    }

    public String statusMessage(FTreeNode node, String oldMessage) {
        IBaseHistogram hist = (IBaseHistogram)node.objectForClass(IBaseHistogram.class);
        if (hist instanceof IManagedObject) {
            String tmp = "Name: " + ((IManagedObject)hist).name() + ", type: " + ((IManagedObject)hist).type();
            return tmp;
        }
        return hist.title();
    }

    public class Commands
    extends CommandProcessor {
        private FTreeNode[] selectedNodes;

        void setSelectedNodes(FTreeNode[] selectedNodes) {
            this.selectedNodes = selectedNodes;
        }

        public void onShow() {
            this.show(false, false, false);
        }

        public void onOverlayonCurrentPlot() {
            this.show(false, true, false);
        }

        public void onShowinNewPlot() {
            this.show(false, false, true);
        }

        public void onShowonNewPage() {
            this.show(true, false, false);
        }

        private void show(boolean newPage, boolean overlay, boolean newPlot) {
            this.show(newPage, overlay, newPlot, true);
        }

        private void show(boolean newPage, boolean overlay, boolean newPlot, boolean firstTry) {
            PlotRegion region = null;
            try {
                PlotPage page;
                IBaseHistogram hist = this.baseHistogram();
                PlotFactory pf = (PlotFactory)HistogramAdapter.this.app.getLookup().lookup(PlotFactory.class);
                PlotPage plotPage = page = newPage ? null : pf.currentPage();
                if (page == null) {
                    page = pf.createPage(null);
                    page.createRegions(1, 1);
                    page.showPage();
                }
                if ((region = page.currentRegion()) == null) {
                    region = page.createRegion(0.0, 0.0, 1.0, 1.0);
                } else if (newPlot) {
                    region = page.addRegion();
                }
                Plotter plotter = region.currentPlot();
                if (plotter == null) {
                    plotter = pf.createPlotterFor(hist.getClass());
                }
                plotter.plot((Object)hist, overlay ? 1 : 0);
                region.showPlot(plotter);
            }
            catch (IllegalArgumentException x) {
                if (firstTry && !newPage && !newPlot) {
                    region.clear();
                    this.show(newPage, overlay, newPlot, false);
                }
                HistogramAdapter.this.app.error("Error showing plot", (Throwable)x);
            }
        }

        public void onClear() {
            IBaseHistogram hist = this.baseHistogram();
            hist.reset();
        }

        public void enableClear(CommandState state) {
            IBaseHistogram hist = this.baseHistogram();
            state.setEnabled(hist.entries() > 0);
        }

        public void onDelete() {
            Tree masterTree = HistogramAdapter.this.thePlugin.aidaMasterTree();
            masterTree.rm(masterTree.findPath((IManagedObject)this.baseHistogram()));
        }

        private IBaseHistogram baseHistogram() {
            FTreeNode[] nodes = this.selectedNodes;
            return (IBaseHistogram)nodes[0].objectForClass(IBaseHistogram.class);
        }
    }
}

