/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.focalplane.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

public class DataGroupFilter
extends AbstractChannelsFilter {
    private final String dataGroup;
    private final String agentName;
    public static final List<String> FIELDS = new ArrayList<String>();

    public DataGroupFilter(String agent, String dataGroup) {
        this.dataGroup = dataGroup;
        this.agentName = agent == null || agent.isEmpty() ? null : agent;
    }

    public String getName() {
        return "FP:" + this.dataGroup;
    }

    public List<String> getAgents() {
        return this.agentName == null ? null : Collections.singletonList(this.agentName);
    }

    public List<String> getFields(boolean compact) {
        return FIELDS;
    }

    public List<String> getOriginChannels() {
        return Collections.singletonList(DataProviderInfo.Attribute.DATA_GROUP.getName() + "=" + this.dataGroup);
    }

    public String getDisplayPath(String originPath) {
        return this.agentName == null ? originPath : originPath.substring(originPath.indexOf("/") + 1);
    }

    public String getOriginPath(String displayPath) {
        return this.agentName == null ? displayPath : this.agentName + "/" + displayPath;
    }

    static {
        FIELDS.add(MonitorField.VALUE.getKey());
        FIELDS.add(MonitorField.UNITS.getKey());
        FIELDS.add(MonitorField.LOW_ALARM.getKey());
        FIELDS.add(MonitorField.LOW_WARN.getKey());
        FIELDS.add(MonitorField.ALERT_LOW.getKey());
        FIELDS.add(MonitorField.HIGH_WARN.getKey());
        FIELDS.add(MonitorField.HIGH_ALARM.getKey());
        FIELDS.add(MonitorField.ALERT_HIGH.getKey());
        FIELDS.add(MonitorField.NAME.getKey());
        FIELDS.add(MonitorField.DESCR.getKey());
    }
}

