/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.diagnostics;

import java.util.HashMap;

public class Profiler {
    private static final HashMap<String, Profiler> instances = new HashMap(2);
    public static final Profiler timer = new Profiler();
    private long time = System.currentTimeMillis();
    private final StringBuilder sb;

    public Profiler() {
        this.sb = new StringBuilder("\nDefault Timer:\n");
    }

    public Profiler(String name) {
        this.sb = new StringBuilder("\nTimer ").append(name).append(":\n");
    }

    public void mark() {
        this.mark("");
    }

    public void mark(String message) {
        long current = System.currentTimeMillis();
        this.sb.append(current - this.time).append(" : ").append(message).append("\n");
        this.time = current;
    }

    public void print() {
        System.out.println(this.sb.toString());
    }

    public static Profiler getInstance() {
        return timer;
    }

    public static Profiler getInstance(String name) {
        Profiler out = instances.get(name);
        if (out == null) {
            out = new Profiler(name);
            instances.put(name, out);
        }
        return out;
    }
}

