package org.lsst.ccs.subsystem.common.ui;

import java.awt.Color;
import javax.swing.JTextField;

/**
 **  Implements some text field extensions.
 **
 **  @author Owen Saxton
 */
public class TextFieldX extends JTextField {

    public static final int
        TYPE_TEXT   = 0,
        TYPE_INT    = 1,
        TYPE_DOUBLE = 2;

    private final int type;
    private boolean editing;
    private String currText;

    public TextFieldX(String text, int typ) {
        super(text);
        currText = text;
        type = typ;
        editing = false;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        currText = text;
    }

    public void update(Object value, boolean enable) {
        if (enable) {
            setEnabled(true);
        }
        if (!editing) {
            setText(String.valueOf(value));
        }
    }

    public void keyTyped(char key) {
        if (!editing && (key >= ' ' || key == '\b')) {
            setEditing(true);
        }
    }

    public void focusLost() {
        if (editing) {
            setEditing(false);
            setText(currText);
        }
    }

    public Object action() {
        if (editing) {
            setEditing(false);
            Object value;
            try {
                if (type == TYPE_DOUBLE) {
                    value = Double.valueOf(getText());
                }
                else if (type == TYPE_INT) {
                    value = Integer.valueOf(getText());
                }
                else {
                    value = getText();
                }
                setEnabled(false);
                currText = getText();
                return value;
            }
            catch(NumberFormatException nfe) {
                setText(currText);
                return null;
            }
        }
        return null;
    }

    public void setDisabled() {
        setEditing(false);
        setEnabled(false);
    }

    private void setEditing(boolean state) {
        editing = state;
        setForeground(editing ? Color.RED : Color.BLACK);
    }
    
    private static final long serialVersionUID = 1L;
}
