/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;

public class RegExRenamingFilter
extends AbstractChannelsFilter {
    public static final String CREATOR_PATH = "Built-In/Basic/Regular Expression, Renaming";
    private final String name;
    private final String regex;
    private final String template;
    private final List<String> agents;
    private final Pattern pattern;

    @Create(category="AgentChannelsFilter", name="Regular expression filter", path="Built-In/Basic/Regular Expression, Renaming", description="Channels filter that uses a regular expression to select channels and leaves their paths unchanged.")
    public RegExRenamingFilter(@Par(def="RegEx", desc="Filter name.") String name, @Par(desc="Regular expression to be applied to the channel path.") String regex, @Par(def="true", desc="Match the whole path. If checked, a channel is accepted only if the provided regular expression matches its entire path. Otherwise, a channel is accepted if the regular expression matches any part of the path.") boolean wholePath, @Par(def="_null_", desc="Display path template. Each occurrence of ${name} or $g will be replaced by the result of evaluating the corresponding group(name) or group(g) from the regular expression match. If null, the original path will be used as the display path.") String displayPath, @Par(def="_null_", desc="List of accepted subsystem names. If null, channels from all subsystems can be accepted.") List<String> subsystems) {
        this.name = null;
        if (regex == null || ((String)regex).isEmpty()) {
            throw new IllegalArgumentException("The regular expression cannot be empty");
        }
        regex = wholePath ? "^" + (String)regex + "$" : "^.*?" + (String)regex + ".*?$";
        this.pattern = Pattern.compile((String)regex);
        this.regex = regex;
        this.template = displayPath;
        this.agents = subsystems == null || subsystems.isEmpty() ? null : Collections.unmodifiableList(new ArrayList<String>(subsystems));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getAgents() {
        return this.agents;
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList(this.regex);
    }

    @Override
    public String getDisplayPath(String originPath) {
        Matcher matcher = this.pattern.matcher(originPath);
        if (matcher.matches()) {
            if (this.template == null) {
                return originPath;
            }
            StringBuffer sb = new StringBuffer();
            matcher.appendReplacement(sb, this.template);
            return sb.toString();
        }
        return null;
    }

    @Override
    public String getOriginPath(String displayPath) {
        return this.template == null ? displayPath : null;
    }

    public static void main(String ... args) {
        RegExRenamingFilter filter = new RegExRenamingFilter(null, "(r)", true, "te$1st$1", null);
        System.out.println(filter.getDisplayPath("rr"));
        filter = new RegExRenamingFilter(null, "x(r).*(p)", false, "do/$1/once/$2", null);
        System.out.println(filter.getDisplayPath("xrrefewp"));
    }
}

