/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.rest.file.server.client.RestFileSystemOptions;

public class RemoteFileServer {
    private static final Logger LOG = Logger.getLogger(RemoteFileServer.class.getName());
    private static final Map<String, FileSystem> fileSystems = new ConcurrentHashMap<String, FileSystem>();
    private final String cacheName;
    private final String mountPoint;

    public RemoteFileServer(String descName, String mountPoint) {
        this(descName, mountPoint, new Properties());
    }

    public RemoteFileServer(String descName, String mountPoint, Properties p) {
        this.mountPoint = mountPoint.replace("/", "");
        this.cacheName = descName + "/" + mountPoint + "/";
        this.getFileSystem(p);
    }

    public InputStream getInputStream(Path path, OpenOption ... options) throws IOException {
        InputStream inputStream;
        block10: {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputStream in = Files.newInputStream(path, options);
            try {
                LOG.log(Level.FINE, "Loading input stream {0} with options {1}", new Object[]{path, Arrays.asList(options)});
                inputStream = in;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException x) {
                    LOG.log(Level.WARNING, "Did not find {0} with options {1}", new Object[]{path, Arrays.asList(options)});
                    throw x;
                }
            }
            in.close();
        }
        return inputStream;
    }

    public boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    public BufferedWriter getBufferedWriter(Path path, OpenOption ... options) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        LOG.log(Level.FINE, "Getting buffered writer {0} with options {1}", new Object[]{path, Arrays.asList(options)});
        return Files.newBufferedWriter(path, options);
    }

    public OutputStream getOutputStream(Path path, OpenOption ... options) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        LOG.log(Level.FINE, "Getting OutputStream {0} with options {1}", new Object[]{path, Arrays.asList(options)});
        return Files.newOutputStream(path, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem getFileSystem(String cacheName, String mountPoint, Properties p) throws ConfigurationServiceException {
        Map<String, FileSystem> map = fileSystems;
        synchronized (map) {
            return fileSystems.computeIfAbsent(cacheName, k -> RemoteFileServer.createFileSystem(k, mountPoint, p));
        }
    }

    private static synchronized FileSystem createFileSystem(String cacheName, String mountPoint, Properties p) throws ConfigurationServiceException {
        try {
            Properties bootstrapSystemProperties = BootstrapResourceUtils.getBootstrapSystemProperties();
            Object uri = p.getProperty("org.lsst.ccs.remote.server.uri", "");
            if (((String)uri).isEmpty() && ((String)(uri = bootstrapSystemProperties.getProperty("org.lsst.ccs.remote.server.uri", ""))).isEmpty()) {
                uri = bootstrapSystemProperties.getProperty("org.lsst.ccs.config.remote.uri", "ccs://lsst-camera-dev.slac.stanford.edu/RestFileServer/");
            }
            boolean cacheOnly = "true".equalsIgnoreCase(bootstrapSystemProperties.getProperty("org.lsst.ccs.config.remote.cacheOnly", "false"));
            Path cacheDir = Paths.get(System.getProperty("user.home") + "/ccs/cache/" + cacheName, new String[0]);
            LOG.log(Level.INFO, "Connecting to remote file server: {0} with mount point \"{1}\" (local cache {2})", new Object[]{uri, mountPoint, cacheDir});
            RestFileSystemOptions.CacheFallback cacheFallback = RestFileSystemOptions.CacheFallback.valueOf((String)p.getProperty("cacheFallback", "offline").toUpperCase());
            if (cacheOnly) {
                cacheFallback = RestFileSystemOptions.CacheFallback.ALWAYS;
            }
            if (!((String)uri).endsWith("/")) {
                uri = (String)uri + "/";
            }
            URI mountPointURI = URI.create(mountPoint + "/");
            URI restRootURI = new URI((String)uri);
            Files.createDirectories(cacheDir, new FileAttribute[0]);
            Map env = RestFileSystemOptions.builder().mountPoint(mountPointURI).cacheLocation(cacheDir.toFile()).set(RestFileSystemOptions.CacheOptions.MEMORY_AND_DISK).ignoreLockedCache(true).set(cacheFallback).set(((String)uri).contains("//lsst-camera-dev.slac.stanford.edu") ? RestFileSystemOptions.SSLOptions.TRUE : RestFileSystemOptions.SSLOptions.AUTO).build();
            return FileSystems.newFileSystem(restRootURI, env);
        }
        catch (IOException | URISyntaxException x) {
            throw new ConfigurationServiceException("Unable to create RestFileServerRemoteDAO", x);
        }
    }

    public FileSystem getFileSystem() {
        return RemoteFileServer.getFileSystem(this.cacheName, this.mountPoint, null);
    }

    private FileSystem getFileSystem(Properties p) {
        return RemoteFileServer.getFileSystem(this.cacheName, this.mountPoint, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<String, FileSystem> map = fileSystems;
        synchronized (map) {
            try {
                FileSystem fs = fileSystems.get(this.cacheName);
                if (fs != null && fs.isOpen()) {
                    fs.close();
                    if (fileSystems.remove(this.cacheName) == null) {
                        throw new IllegalArgumentException("Something went wrong when clearing the cache while closing file system with cache " + this.cacheName + ". Available caches: " + fileSystems.keySet());
                    }
                }
            }
            catch (IOException x) {
                LOG.log(Level.WARNING, "Error while closing rest file system", x);
            }
        }
    }
}

