/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import org.freehep.jas.plugin.tree.DefaultFTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeSorter;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

abstract class FTreeNodeSorterManager {
    private static Hashtable sortersHash = new Hashtable();
    private static String stringSeparator = ":-:";
    private static Lookup.Result result;
    private static SorterListener listener;

    FTreeNodeSorterManager() {
    }

    private static FTreeNodeSorter sorter(String sorterName) {
        Collection availableSorters = FTreeNodeSorterManager.availableSorters();
        for (FTreeNodeSorter sorter : availableSorters) {
            if (!sorter.algorithmName().equals(sorterName)) continue;
            return sorter;
        }
        throw new IllegalArgumentException("Sorter \"" + sorterName + "\" does not exist");
    }

    static Collection availableSorters() {
        result = FreeHEPLookup.instance().lookup(new Lookup.Template(FTreeNodeSorter.class));
        return result.allInstances();
    }

    static synchronized String sortingString(Collection sorters) {
        int size = sorters.size();
        if (size == 0) {
            return null;
        }
        String sortingString = new String();
        Iterator iter = sorters.iterator();
        while (iter.hasNext()) {
            if (!sortingString.equals("")) {
                sortingString = sortingString + stringSeparator;
            }
            sortingString = sortingString + ((FTreeNodeSorter)iter.next()).algorithmName();
        }
        if (!sortersHash.contains(sortingString)) {
            sortersHash.put(sortingString, new SorterComparator(sorters));
        }
        return sortingString;
    }

    static synchronized SorterComparator sortingComparator(String sortingString) {
        Object obj = sortersHash.get(sortingString);
        if (obj == null) {
            ArrayList<FTreeNodeSorter> sorters = new ArrayList<FTreeNodeSorter>();
            while (true) {
                int index;
                if ((index = sortingString.indexOf(stringSeparator)) == -1) {
                    index = sortingString.length();
                }
                String sorterName = sortingString.substring(0, index);
                sorters.add(FTreeNodeSorterManager.sorter(sorterName));
                sortingString = sortingString.substring(index);
                if (sortingString.length() <= 0) break;
                sortingString = sortingString.substring(3);
            }
            obj = new SorterComparator(sorters);
            sortersHash.put(sortingString, obj);
        }
        return (SorterComparator)obj;
    }

    static synchronized void startListerning() {
        if (listener != null) {
            return;
        }
        FTreeNodeSorterManager.doStartListerning();
    }

    static synchronized void stopListerning() {
        if (listener == null) {
            return;
        }
        FTreeNodeSorterManager.doStopListerning();
    }

    private static void doStartListerning() {
        listener = new SorterListener();
        if (result == null) {
            result = FreeHEPLookup.instance().lookup(new Lookup.Template(FTreeNodeSorter.class));
        }
        result.addLookupListener((LookupListener)listener);
    }

    private static void doStopListerning() {
        if (result == null) {
            return;
        }
        result.removeLookupListener((LookupListener)listener);
        result = null;
        listener = null;
    }

    private static synchronized void refillHash() {
        sortersHash.clear();
    }

    static class SorterComparator
    implements Comparator {
        private Collection sorters;

        SorterComparator() {
            this(new ArrayList());
        }

        SorterComparator(Collection sorters) {
            this.sorters = sorters;
        }

        public int compare(Object p1, Object p2) {
            int result = 0;
            DefaultFTreeNode node1 = (DefaultFTreeNode)p1;
            DefaultFTreeNode node2 = (DefaultFTreeNode)p2;
            Iterator iter = this.sorters.iterator();
            while (iter.hasNext() && (result = ((FTreeNodeSorter)iter.next()).sort(node1, node2)) == 0) {
            }
            return result;
        }

        Collection sorters() {
            return this.sorters;
        }
    }

    static class SorterListener
    implements LookupListener {
        SorterListener() {
        }

        public void resultChanged(LookupEvent ev) {
            FTreeNodeSorterManager.refillHash();
        }
    }
}

