package org.lsst.ccs.subsystem.common.ui.focalplane.view;

import java.util.List;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.SummaryTableView;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.FocalPlaneFilter;

/**
 * {@link FocalPlaneView} that displays data in a tree-table, using filter-created groups as columns and focal plane segments as rows.
 *
 * @author onoprien
 */
public class SummaryView extends SummaryTableView implements FocalPlaneView {

// -- Fields : -----------------------------------------------------------------
    
    static public final String PATH = "Built-In/Summary Table";

// -- Life cycle : -------------------------------------------------------------
    
    @Create(category = FocalPlaneView.CATEGORY,
            name = "Summary Table",
            path = PATH,
            description = "Tree-table based summary table.")
    public SummaryView() {
    }
    
// -- Override AbstractMonitorView : -------------------------------------------

    @Override
    public FocalPlaneFilter getFilter() {
        return (FocalPlaneFilter) super.getFilter();
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        if (filter instanceof FocalPlaneFilter) {
            super.setFilter(filter);
        } else {
            throw new IllegalArgumentException("SummaryView only accepts FocalPlaneFilter filters. Attempted: "+ (filter == null ? "null" : filter.getClass().getName()) +".");
        }
    }

    @Override
    public List<String> getGroups() {
        List<String> out = FocalPlaneView.super.getGroups();
        if (out == null) out = super.getGroups();
        return out;
    }

}
