/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui;

import java.awt.Color;
import javax.swing.JTextField;

public class TextFieldX
extends JTextField {
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_DOUBLE = 2;
    private final int type;
    private boolean editing;
    private String currText;
    private static final long serialVersionUID = 1L;

    public TextFieldX(String text, int typ) {
        super(text);
        this.currText = text;
        this.type = typ;
        this.editing = false;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.currText = text;
    }

    public void update(Object value, boolean enable) {
        if (enable) {
            this.setEnabled(true);
        }
        if (!this.editing) {
            this.setText(String.valueOf(value));
        }
    }

    public void keyTyped(char key) {
        if (!(this.editing || key < ' ' && key != '\b')) {
            this.setEditing(true);
        }
    }

    public void focusLost() {
        if (this.editing) {
            this.setEditing(false);
            this.setText(this.currText);
        }
    }

    public Object action() {
        if (this.editing) {
            this.setEditing(false);
            try {
                Object value = this.type == 2 ? Double.valueOf(this.getText()) : (this.type == 1 ? Integer.valueOf(this.getText()) : this.getText());
                this.setEnabled(false);
                this.currText = this.getText();
                return value;
            }
            catch (NumberFormatException nfe) {
                this.setText(this.currText);
                return null;
            }
        }
        return null;
    }

    public void setDisabled() {
        this.setEditing(false);
        this.setEnabled(false);
    }

    private void setEditing(boolean state) {
        this.editing = state;
        this.setForeground(this.editing ? Color.RED : Color.BLACK);
    }
}

