/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.data.BasicState;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;

public class BasicControlPanel
extends JPanel
implements CommandSender.ReplyHandler {
    private final CommandSender sender;
    private SystemStatusPanel statusPanel;
    private static final long serialVersionUID = 1L;

    public BasicControlPanel(String subsys) {
        this.sender = new CommandSender(subsys, this);
        this.initComponents();
        new DisableControlPanel().run();
    }

    public void initControlPanel() {
        this.sender.sendCommand(true, null, "getFullState", new Object[0]);
    }

    @Override
    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updateControlPanel((BasicState)reply);
    }

    public void updateControlPanel(BasicState state) {
        SwingUtilities.invokeLater(new UpdateControlPanel(state));
    }

    public void disableControlPanel() {
        SwingUtilities.invokeLater(new DisableControlPanel());
    }

    private void initComponents() {
        this.statusPanel = new SystemStatusPanel(this.sender, "MonitorControl");
        this.add(this.statusPanel);
    }

    class DisableControlPanel
    implements Runnable {
        DisableControlPanel() {
        }

        @Override
        public void run() {
            BasicControlPanel.this.statusPanel.disablePanel();
            BasicControlPanel.this.repaint();
        }
    }

    class UpdateControlPanel
    implements Runnable {
        private final BasicState state;

        UpdateControlPanel(BasicState state) {
            this.state = state;
        }

        @Override
        public void run() {
            BasicControlPanel.this.statusPanel.updatePanel(this.state.getTickMillis());
            BasicControlPanel.this.repaint();
        }
    }
}

