/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.lsst.ccs.command.AmbiguousCommandException;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.DictionaryHelpGenerator;
import org.lsst.ccs.command.annotations.Command;

public class CompositeCommandDictionary
implements Dictionary {
    private static final long serialVersionUID = 6746559441105266344L;
    private final Set<Dictionary> dicts = new CopyOnWriteArraySet<Dictionary>();
    private final CompositeCommandDictionaryCompleter completer = new CompositeCommandDictionaryCompleter(this.dicts);
    private transient Map<String, Boolean> visibilityByCategory = new ConcurrentHashMap<String, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Dictionary commandDictionary) {
        Set<Dictionary> set = this.dicts;
        synchronized (set) {
            this.dicts.add(commandDictionary);
            for (String cat : this.visibilityByCategory.keySet()) {
                commandDictionary.setCategoryVisible(Command.CommandCategory.valueOf(cat), this.visibilityByCategory.get(cat));
            }
        }
    }

    public void remove(Dictionary commandDictionary) {
        this.dicts.remove(commandDictionary);
    }

    void clear() {
        this.dicts.clear();
    }

    @Override
    public DictionaryCompleter getDictionaryCompleter() {
        return this.completer;
    }

    @Override
    public boolean containsCommand(BasicCommand tc) throws CommandArgumentMatchException {
        ArrayList<CommandArgumentMatchException> exceptions = new ArrayList<CommandArgumentMatchException>();
        for (Dictionary dict : this.dicts) {
            try {
                if (!dict.containsCommand(tc)) continue;
                return true;
            }
            catch (CommandArgumentMatchException ex) {
                exceptions.add(ex);
            }
        }
        CommandArgumentMatchException.throwExceptionIfNeeded(exceptions);
        return false;
    }

    @Override
    public DictionaryCommand findCommand(BasicCommand tc) throws CommandArgumentMatchException {
        ArrayList<DictionaryCommand> matches = new ArrayList<DictionaryCommand>();
        ArrayList<CommandArgumentMatchException> exceptions = new ArrayList<CommandArgumentMatchException>();
        for (Dictionary dict : this.dicts) {
            try {
                if (!dict.containsCommand(tc)) continue;
                matches.add(dict.findCommand(tc));
            }
            catch (CommandArgumentMatchException ex) {
                exceptions.add(ex);
            }
        }
        if (matches.isEmpty()) {
            CommandArgumentMatchException.throwExceptionIfNeeded(exceptions);
            return null;
        }
        if (matches.size() == 1) {
            return (DictionaryCommand)matches.get(0);
        }
        throw new AmbiguousCommandException("Found " + matches.size() + " matches when looking for command " + tc.getCommand() + " with " + tc.getArgumentCount() + " arguments");
    }

    @Override
    public Iterator<DictionaryCommand> iterator() {
        ArrayList<DictionaryCommand> allCommands = new ArrayList<DictionaryCommand>();
        for (Dictionary dict : this.dicts) {
            for (DictionaryCommand def : dict) {
                allCommands.add(def);
            }
        }
        return allCommands.iterator();
    }

    @Override
    public int size() {
        int result = 0;
        for (Dictionary dict : this.dicts) {
            result += dict.size();
        }
        return result;
    }

    @Override
    public DictionaryHelpGenerator getHelpGenerator() {
        return new CompositeCommandDictionaryHelpGenerator(this.dicts);
    }

    public Set<Dictionary> getDictionaries() {
        return this.dicts;
    }

    @Override
    public void setLevelForTypes(int level, Command.CommandType ... types) {
        Command.CommandType[] innerTypes = types == null || types.length == 0 ? Command.CommandType.values() : types;
        this.dicts.forEach(d -> d.setLevelForTypes(level, innerTypes));
    }

    @Override
    public int getLevelForType(Command.CommandType type) {
        for (Dictionary dict : this.dicts) {
            int level = dict.getLevelForType(type);
            if (level == 99999) continue;
            return level;
        }
        return 99999;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCategoryVisible(Command.CommandCategory category, boolean isVisible) {
        Set<Dictionary> set = this.dicts;
        synchronized (set) {
            this.visibilityByCategory.put(category.name(), isVisible);
            this.dicts.forEach(d -> d.setCategoryVisible(category, isVisible));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCategoryVisible(Command.CommandCategory category) {
        Set<Dictionary> set = this.dicts;
        synchronized (set) {
            if (this.visibilityByCategory.containsKey(category.name())) {
                return this.visibilityByCategory.get(category.name());
            }
            for (Dictionary dict : this.dicts) {
                boolean isVisible = dict.isCategoryVisible(category);
                if (isVisible) continue;
                return false;
            }
            return true;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.visibilityByCategory == null) {
            this.visibilityByCategory = new ConcurrentHashMap<String, Boolean>();
        }
    }

    private static class CompositeCommandDictionaryCompleter
    implements DictionaryCompleter {
        private static final long serialVersionUID = -6939187939493084396L;
        private final Set<Dictionary> dicts;

        CompositeCommandDictionaryCompleter(Set<Dictionary> dicts) {
            this.dicts = dicts;
        }

        @Override
        public int complete(String buffer, int cursor, List<CharSequence> list) {
            ArrayList<CharSequence> compositeCompletionList = new ArrayList<CharSequence>();
            int returnValue = -1;
            for (Dictionary dict : this.dicts) {
                int completionValue;
                ArrayList<CharSequence> innerCompletionList = new ArrayList<CharSequence>();
                DictionaryCompleter innerCompleter = dict.getDictionaryCompleter();
                if (innerCompleter == null || (completionValue = innerCompleter.complete(buffer, cursor, innerCompletionList)) < returnValue || completionValue == -1) continue;
                if (completionValue > returnValue) {
                    compositeCompletionList.clear();
                }
                compositeCompletionList.addAll(innerCompletionList);
                returnValue = completionValue;
            }
            list.addAll(compositeCompletionList);
            return returnValue;
        }
    }

    private static class CompositeCommandDictionaryHelpGenerator
    implements DictionaryHelpGenerator {
        private static final long serialVersionUID = -960170507549440673L;
        private final Set<Dictionary> dictionaries;

        CompositeCommandDictionaryHelpGenerator(Set<Dictionary> dicts) {
            this.dictionaries = dicts;
        }

        @Override
        public boolean hasHelp(DictionaryCommand command) {
            for (Dictionary dic : this.dictionaries) {
                DictionaryHelpGenerator helpGenerator = dic.getHelpGenerator();
                if (helpGenerator == null || !helpGenerator.hasHelp(command)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String modifyHelpForCommand(DictionaryCommand command, String help, boolean compact) {
            for (Dictionary dic : this.dictionaries) {
                DictionaryHelpGenerator helpGenerator = dic.getHelpGenerator();
                if (helpGenerator == null || !helpGenerator.hasHelp(command)) continue;
                help = helpGenerator.modifyHelpForCommand(command, help, compact);
            }
            return help;
        }
    }
}

