/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.focalplane;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.concurrent.CancellationException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.PersistableAgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.LsstMonitorPlugin;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorPage;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.gconsole.services.persist.Creator;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.subsystem.common.focalplane.data.HasFocalPlaneData;
import org.lsst.ccs.subsystem.common.ui.focalplane.FocalPlaneMapPageDialog;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.DataGroupFilter;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.GroupAttributeFilter;
import org.lsst.ccs.subsystem.common.ui.focalplane.view.DiagramView;
import org.lsst.ccs.subsystem.common.ui.focalplane.view.MultiMapView;
import org.lsst.ccs.subsystem.common.ui.focalplane.view.SummaryView;

@Plugin(name="LSST CCS Commons Focal Plane", id="commons-focal-plane", description="LSST CCS support for focal plane views")
public class FocalPlanePlugin
extends ConsolePlugin {
    public static final String MONITOR_PAGE_CATEGORY = "FocalPlaneMonitorPage";
    private AgentPresenceListener agentPresenceListener;

    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new FocalPlaneMonitoringOptionalPage());
    }

    public void start() {
        this.initFocalPlaneMaps();
        final LsstMonitorPlugin monitorPlugin = (LsstMonitorPlugin)this.getConsole().getSingleton(LsstMonitorPlugin.class);
        if (monitorPlugin != null) {
            AbstractAction act = new AbstractAction("New..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FocalPlanePlugin.this.openNewMonitorPage(monitorPlugin);
                }
            };
            monitorPlugin.getServices().addMenu((Action)act, new String[]{"400: CCS Tools :-1:15", LsstMonitorPlugin.MENU_NAME + ":2:1", "Focal Plane:1"});
            act = new AbstractAction("Load..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PersistenceService service = (PersistenceService)FocalPlanePlugin.this.getConsole().getSingleton(PersistenceService.class);
                    try {
                        Persistable.Descriptor desc = service.load(FocalPlanePlugin.MONITOR_PAGE_CATEGORY, "Load monitoring page", (Component)FocalPlanePlugin.this.getConsole().getWindow());
                        if (desc instanceof MonitorPage.Descriptor) {
                            MonitorPage page = (MonitorPage)service.make(desc);
                            monitorPlugin.openManagedPage(page);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            };
            monitorPlugin.getServices().addMenu((Action)act, new String[]{"400: CCS Tools :-1:15", LsstMonitorPlugin.MENU_NAME + ":2:1", "Focal Plane:2"});
        }
    }

    public void stop() {
        this.getConsole().getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(this.agentPresenceListener);
        this.agentPresenceListener = null;
    }

    private void openNewMonitorPage(LsstMonitorPlugin monitorPlugin) {
        try {
            MonitorPage monPage = new MonitorPage();
            monPage.getDescriptor().setCategory(MONITOR_PAGE_CATEGORY);
            monPage.getDescriptor().setName("FP Mon");
            Persistable.Descriptor viewDesc = new Persistable.Descriptor();
            Creator.Descriptor creDesc = new Creator.Descriptor("FocalPlaneView", "Built-In/Summary Table", new String[0]);
            viewDesc.setCreator(creDesc);
            monPage.getDescriptor().setView(viewDesc);
            Persistable.Descriptor filterDesc = new Persistable.Descriptor();
            filterDesc.setCategory("FocalPlaneFilter");
            monPage.getDescriptor().setFilter(filterDesc);
            monPage = monPage.edit("Open Focal Plane Monitor Page", null);
            monitorPlugin.openManagedPage(monPage);
        }
        catch (CancellationException monPage) {
        }
        catch (RuntimeException x) {
            this.getConsole().error("Error opening monitor page", (Exception)x);
        }
    }

    private void initFocalPlaneMaps() {
        this.agentPresenceListener = new AgentPresenceListener(){

            public void connected(AgentInfo ... agents) {
                SwingUtilities.invokeLater(() -> {
                    for (AgentInfo agent : agents) {
                        if (agent.getAgentProperty(HasFocalPlaneData.AGENT_PROPERTY, "").trim().isEmpty()) continue;
                        final String agentName = agent.getName();
                        AbstractAction act = new AbstractAction("Custom..."){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                FocalPlaneMapPageDialog d = FocalPlaneMapPageDialog.show(null, agentName + " map");
                                if (d != null) {
                                    FocalPlanePlugin.this.openFocalPlaneMapPage(agentName, d.getRows(), d.getColumns(), d.getPageTitle());
                                }
                            }
                        };
                        FocalPlanePlugin.this.getServices().addMenu((Action)act, new String[]{"CCS Subsystems", agentName, "Focal plane", "Map"});
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 1, 1);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 1, 2);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 2, 1);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 2, 2);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 1, 3);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 2, 3);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 3, 3);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 4, 4);
                        act = new AbstractAction("Diagram"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                FocalPlanePlugin.this.openFocalPlaneDiagramPage(agentName);
                            }
                        };
                        FocalPlanePlugin.this.getServices().addMenu((Action)act, new String[]{"CCS Subsystems", agentName, "Focal plane"});
                        act = new AbstractAction("Summary"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                FocalPlanePlugin.this.openFocalPlaneSummaryPage(agentName);
                            }
                        };
                        FocalPlanePlugin.this.getServices().addMenu((Action)act, new String[]{"CCS Subsystems", agentName, "Focal plane"});
                    }
                });
            }
        };
        this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.agentPresenceListener);
    }

    private void addFocalPlaneMapMenu(final String agent, final int rows, final int columns) {
        AbstractAction act = new AbstractAction(columns + " x " + rows){

            @Override
            public void actionPerformed(ActionEvent e) {
                FocalPlanePlugin.this.openFocalPlaneMapPage(agent, rows, columns, null);
            }
        };
        this.getServices().addMenu((Action)act, new String[]{"CCS Subsystems", agent, "Focal plane", "Map"});
    }

    private void openFocalPlaneMapPage(String agent, int rows, int columns, String title) {
        if (title == null || title.trim().isEmpty()) {
            title = agent + " map";
        }
        MonitorPage.Descriptor pageDesc = new MonitorPage.Descriptor();
        pageDesc.setCategory(MONITOR_PAGE_CATEGORY);
        pageDesc.setName(title);
        MultiMapView.Descriptor viewDesc = new MultiMapView.Descriptor();
        Creator.Descriptor cd = new Creator.Descriptor();
        cd.setParameters(new String[]{Integer.toString(rows), Integer.toString(columns)});
        cd.setPath("Built-In/Map/Multi-Region");
        viewDesc.setCreator(cd);
        viewDesc.setRows(rows);
        viewDesc.setColumns(columns);
        pageDesc.setView((Persistable.Descriptor)viewDesc);
        GroupAttributeFilter.Descriptor filterDesc = new GroupAttributeFilter.Descriptor();
        cd = new Creator.Descriptor();
        cd.setPath("Built-In/Standard Groups/One Subsystem");
        cd.setParameters(new String[]{agent});
        filterDesc.setCreator(cd);
        filterDesc.setAgent(agent);
        pageDesc.setFilter((Persistable.Descriptor)filterDesc);
        LsstMonitorPlugin monPlugin = (LsstMonitorPlugin)Console.getConsole().getSingleton(LsstMonitorPlugin.class);
        monPlugin.openManagedPage(pageDesc);
    }

    private void openFocalPlaneDiagramPage(String agent) {
        MonitorPage.Descriptor pageDesc = new MonitorPage.Descriptor();
        pageDesc.setCategory(MONITOR_PAGE_CATEGORY);
        pageDesc.setName(agent + " diagram");
        DiagramView.Descriptor viewDesc = new DiagramView.Descriptor();
        Creator.Descriptor cd = new Creator.Descriptor();
        cd.setParameters(new String[0]);
        cd.setPath("Built-In/Diagram");
        viewDesc.setCreator(cd);
        viewDesc.setName("Focal Plane Diagram");
        pageDesc.setView((Persistable.Descriptor)viewDesc);
        GroupAttributeFilter.Descriptor filterDesc = new GroupAttributeFilter.Descriptor();
        cd = new Creator.Descriptor();
        cd.setPath("Built-In/Standard Groups/One Subsystem");
        cd.setParameters(new String[]{agent});
        filterDesc.setCreator(cd);
        filterDesc.setName("Standard data groups");
        filterDesc.setAgent(agent);
        pageDesc.setFilter((Persistable.Descriptor)filterDesc);
        LsstMonitorPlugin monPlugin = (LsstMonitorPlugin)Console.getConsole().getSingleton(LsstMonitorPlugin.class);
        monPlugin.openManagedPage(pageDesc);
    }

    private void openFocalPlaneSummaryPage(String agent) {
        PersistenceService service = (PersistenceService)Console.getConsole().getSingleton(PersistenceService.class);
        SummaryView view = (SummaryView)service.make("FocalPlaneView", "Built-In/Summary Table", new Object[0]);
        GroupAttributeFilter filter = (GroupAttributeFilter)service.make("FocalPlaneFilter", "Built-In/Standard Groups/One Subsystem", new Object[]{agent});
        MonitorPage page = new MonitorPage((PersistableMonitorView)view, (PersistableAgentChannelsFilter)filter, agent + " summary");
        page.getDescriptor().setCategory(MONITOR_PAGE_CATEGORY);
        LsstMonitorPlugin monPlugin = (LsstMonitorPlugin)Console.getConsole().getSingleton(LsstMonitorPlugin.class);
        monPlugin.openManagedPage(page);
    }

    private static final class DataGroupMonitor
    extends JPanel {
        private final JComboBox<String> dataSelector;
        private final AgentInfo agent;
        SectionedTableView view = new SectionedTableView();

        DataGroupMonitor(AgentInfo agent) {
            this.agent = agent;
            this.setLayout(new BorderLayout());
            this.setName(agent.getName());
            String prop = agent.getAgentProperty(HasFocalPlaneData.AGENT_PROPERTY);
            String[] ss = HasFocalPlaneData.getFocalPlaneDataGroups((String)prop);
            this.dataSelector = new JComboBox<String>(ss);
            this.add(this.dataSelector, "First");
            this.makeFilteredTable();
            this.dataSelector.addActionListener(e -> {
                this.remove(this.view.getPanel());
                this.view = new SectionedTableView();
                this.makeFilteredTable();
            });
        }

        final void makeFilteredTable() {
            DataGroupFilter monitorFilter = new DataGroupFilter(this.agent.getName(), (String)this.dataSelector.getSelectedItem());
            this.view.uninstall();
            this.view.setFilter((AgentChannelsFilter)monitorFilter);
            this.view.install();
            this.add((Component)this.view.getPanel(), "Center");
            this.revalidate();
            this.repaint();
        }
    }

    static class FocalPlaneMonitoringOptionalPage
    implements OptionalPage {
        FocalPlaneMonitoringOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            if (agent != null && agent.hasAgentProperty(HasFocalPlaneData.AGENT_PROPERTY)) {
                return "CCS Subsystems/" + agent.getName() + "/Focal plane/Table";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            DataGroupMonitor dataSelection = new DataGroupMonitor(agent);
            return dataSelection;
        }
    }
}

