/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BoundedRangeModel;

public class FileReaderWithProgressBar
extends FileInputStream {
    private BoundedRangeModel m_model;
    private long m_bytesRead = 0L;
    private long m_fileLength;
    private long m_modelRange;
    private int m_modelMin;

    public FileReaderWithProgressBar(String fileName, BoundedRangeModel model) throws FileNotFoundException {
        super(fileName);
        this.m_fileLength = new File(fileName).length();
        if (this.m_fileLength == 0L) {
            this.m_fileLength = 1L;
        }
        this.m_model = model;
        this.m_modelMin = model.getMinimum();
        this.m_modelRange = model.getMaximum() - this.m_modelMin;
    }

    @Override
    public int read() throws IOException {
        int i = super.read();
        if (i != -1) {
            ++this.m_bytesRead;
        }
        this.updateModel();
        return i;
    }

    @Override
    public int read(byte[] cbuf) throws IOException {
        int i = super.read(cbuf);
        if (i > 0) {
            this.m_bytesRead += (long)i;
        }
        this.updateModel();
        return i;
    }

    @Override
    public int read(byte[] cbuf, int off, int len) throws IOException {
        int i = super.read(cbuf, off, len);
        if (i > 0) {
            this.m_bytesRead += (long)i;
        }
        this.updateModel();
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        long rc = super.skip(n);
        this.m_bytesRead += n;
        this.updateModel();
        return rc;
    }

    private void updateModel() {
        long l = this.m_modelRange * this.m_bytesRead / this.m_fileLength;
        this.m_model.setValue(this.m_modelMin + (int)l);
    }
}

