/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.SaveAsPlugin;
import jas.util.FileTypeFileFilter;
import jas.util.encoder.GifEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.filechooser.FileFilter;

public class SaveAsGIF
implements SaveAsPlugin {
    @Override
    public boolean hasOptions() {
        return false;
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileTypeFileFilter("gif", "GIF File (*.gif)");
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public void saveAs(Component c, OutputStream os, File file, Component dialogParent) throws IOException {
        Image img = c.createImage(c.getWidth(), c.getHeight());
        Graphics g = img.getGraphics();
        RepaintManager pm = RepaintManager.currentManager(c);
        boolean save = pm.isDoubleBufferingEnabled();
        pm.setDoubleBufferingEnabled(false);
        c.print(g);
        g.dispose();
        pm.setDoubleBufferingEnabled(save);
        GifEncoder encoder = new GifEncoder(img, os);
        encoder.encode();
        img.flush();
    }

    @Override
    public File adjustFilename(File file) {
        String name = file.getName();
        if (name.endsWith(".gif")) {
            return file;
        }
        int pos = name.indexOf(46);
        if (pos >= 0) {
            name = name.substring(0, pos);
        }
        name = name + ".gif";
        File parent = file.getParentFile();
        return new File(parent, name);
    }

    @Override
    public boolean supportsClass(Object o) {
        return true;
    }

    @Override
    public void saveOptions(Properties props) {
    }

    @Override
    public void restoreOptions(Properties props) {
    }
}

