package org.lsst.ccs.subsystem.common.ui.focalplane.filter;

import java.util.*;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * Filter that selects channels that belong to a certain {@code FocalPlaneDataGroup}.
 * Strips subsystem names from original paths to create display paths.
 *
 * @author The LSST CCS Team
 */
public class DataGroupFilter extends AbstractChannelsFilter {

    private final String dataGroup;
    private final String agentName;

    public final static List<String> FIELDS = new ArrayList<>();
    static {
        FIELDS.add(MonitorField.VALUE.getKey());
        FIELDS.add(MonitorField.UNITS.getKey());
        FIELDS.add(MonitorField.LOW_ALARM.getKey());
        FIELDS.add(MonitorField.LOW_WARN.getKey());
        FIELDS.add(MonitorField.ALERT_LOW.getKey());
        FIELDS.add(MonitorField.HIGH_WARN.getKey());
        FIELDS.add(MonitorField.HIGH_ALARM.getKey());
        FIELDS.add(MonitorField.ALERT_HIGH.getKey());
        FIELDS.add(MonitorField.NAME.getKey());
        FIELDS.add(MonitorField.DESCR.getKey());
                
    }

    public DataGroupFilter(String agent, String dataGroup) {
        this.dataGroup = dataGroup;
        this.agentName = (agent == null || agent.isEmpty()) ? null : agent;
    }

    @Override
    public String getName() {
        return "FP:"+ dataGroup;
    }
    
    @Override
    public List<String> getAgents() {
        return agentName == null ? null : Collections.singletonList(agentName);
    }

    @Override
    public List<String> getFields(boolean compact) {
        return FIELDS;
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList(DataProviderInfo.Attribute.DATA_GROUP.getName()+"="+dataGroup);
    }
    
    @Override
    public String getDisplayPath(String originPath) {
        return agentName == null ? originPath : originPath.substring(originPath.indexOf("/") + 1);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return agentName == null ? displayPath : agentName +"/"+ displayPath;
    }
    
}
