/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.optpage;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.messaging.AgentPresenceListener;

class OptionalPageHandler {
    private final OptionalPage descriptor;
    private final HashMap<String, Page> path2page = new HashMap();
    private boolean stopped = true;
    private HashMap<String, DataPanelDescriptor> state;
    private final AgentPresenceListener listener;

    OptionalPageHandler(OptionalPage descriptor) {
        this.descriptor = descriptor;
        this.listener = new AgentPresenceListener(){

            public void disconnected(AgentInfo ... agents) {
                SwingUtilities.invokeLater(() -> {
                    for (AgentInfo agent : agents) {
                        OptionalPageHandler.this.onDisconnect(agent);
                    }
                });
            }

            public void connected(AgentInfo ... agents) {
                SwingUtilities.invokeLater(() -> {
                    for (AgentInfo agent : agents) {
                        OptionalPageHandler.this.onConnect(agent);
                    }
                });
            }
        };
    }

    void start() {
        this.stopped = false;
        this.onConnect(null);
        Console.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.listener);
    }

    void stop() {
        Console.getConsole().getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(this.listener);
        new ArrayList<Page>(this.path2page.values()).forEach(page -> page.uninstall());
        this.stopped = true;
    }

    OptionalPage getDescriptor() {
        return this.descriptor;
    }

    private void onConnect(AgentInfo agent) {
        String[] pp;
        if (this.stopped) {
            return;
        }
        String path = this.getPath(agent);
        if (path == null) {
            return;
        }
        Page page = this.path2page.get(path);
        if (page == null) {
            page = new Page(path);
            page.install();
        } else if (page.agents.isEmpty() && (pp = page.getMenuPath()).length > 1 && pp[0].contains("CCS Subsystems") && pp[1].contains(agent.getName())) {
            Console.getConsole().addMenu(page, null, pp);
        }
        page.addAgent(agent);
    }

    private void onDisconnect(AgentInfo agent) {
        if (this.stopped) {
            return;
        }
        for (Page page : this.path2page.values()) {
            if (page.removeAgent(agent)) break;
        }
    }

    public HashMap<String, DataPanelDescriptor> save() {
        HashMap<String, DataPanelDescriptor> out = new HashMap<String, DataPanelDescriptor>();
        this.path2page.forEach((path, page) -> out.put((String)path, page.save()));
        return out;
    }

    public void restore(HashMap<String, DataPanelDescriptor> state) {
        this.state = state;
        this.path2page.forEach((path, page) -> {
            DataPanelDescriptor open = (DataPanelDescriptor)state.get(path);
            if (open != null) {
                page.setOpen(open.isOpen());
            }
        });
    }

    void setOpen(AgentInfo agent, boolean isOpen) {
        Page page = this.getPage(agent);
        if (page != null) {
            page.setOpen(isOpen);
        }
    }

    private String getPath(AgentInfo agent) {
        try {
            String name = this.descriptor.getPage(agent);
            if (name != null) {
                String path;
                if (name.trim().isEmpty()) {
                    name = agent.getName();
                }
                if ((path = this.descriptor.getPath()) != null) {
                    name = path + "/" + name;
                }
            }
            return name;
        }
        catch (RuntimeException x) {
            return null;
        }
    }

    private Page getPage(AgentInfo agent) {
        if (this.stopped) {
            return null;
        }
        String path = this.getPath(agent);
        if (path == null) {
            return null;
        }
        Page page = this.path2page.get(path);
        return page;
    }

    private class Page
    extends AbstractAction {
        private final String path;
        JComponent component;
        final ArrayList<AgentInfo> agents;

        Page(String path) {
            super(path.substring(path.lastIndexOf("/") + 1));
            this.agents = new ArrayList(1);
            this.path = path;
        }

        void install() {
            DataPanelDescriptor d = OptionalPageHandler.this.state == null ? null : (DataPanelDescriptor)OptionalPageHandler.this.state.get(this.path);
            boolean open = d == null ? OptionalPageHandler.this.descriptor.isAutoOpen() : d.isOpen();
            this.putValue("SwingSelectedKey", open);
            OptionalPageHandler.this.path2page.put(this.path, this);
            Console.getConsole().addMenu(this, null, this.getMenuPath());
        }

        void uninstall() {
            Console.getConsole().removeMenu(this.path.split("/"));
            if (this.component != null) {
                Console.getConsole().getPanelManager().close(this.component);
            }
            OptionalPageHandler.this.path2page.remove(this.path);
        }

        void addAgent(AgentInfo agent) {
            this.agents.add(agent);
            if (this.isOpen()) {
                this.open(OptionalPageHandler.this.descriptor.open(agent, this.component));
            }
        }

        boolean removeAgent(AgentInfo agent) {
            Iterator<AgentInfo> it = this.agents.iterator();
            while (it.hasNext()) {
                AgentInfo a = it.next();
                if (a == null || !a.getName().equals(agent.getName())) continue;
                it.remove();
                boolean close = OptionalPageHandler.this.descriptor.agentDisconnected(a);
                if (close || !this.isOpen() && this.agents.isEmpty()) {
                    this.uninstall();
                }
                return true;
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isOpen()) {
                this.component = null;
                for (AgentInfo agent : this.agents) {
                    this.open(OptionalPageHandler.this.descriptor.open(agent, this.component));
                }
            } else if (this.component != null) {
                Console.getConsole().getPanelManager().close(this.component);
            }
        }

        boolean isOpen() {
            return (Boolean)this.getValue("SwingSelectedKey");
        }

        void setOpen(boolean open) {
            boolean wasOpen = this.isOpen();
            if (open != wasOpen) {
                this.putValue("SwingSelectedKey", open);
                this.actionPerformed(null);
            }
            if (open && wasOpen && this.component != null) {
                Console.getConsole().getPanelManager().set(this.component, Panel.SELECTED, true);
            }
        }

        DataPanelDescriptor save() {
            boolean open = (Boolean)this.getValue("SwingSelectedKey");
            if (this.component != null && open) {
                return DataPanelDescriptor.get(this.component);
            }
            DataPanelDescriptor d = new DataPanelDescriptor();
            d.setOpen(false);
            return d;
        }

        void restore(DataPanelDescriptor d) {
        }

        void open(JComponent component) {
            if (component == null) {
                return;
            }
            if (this.component != component) {
                HashMap<String, Serializable> data;
                DataPanelDescriptor d;
                if (this.component != null) {
                    PanelManager pm = Console.getConsole().getPanelManager();
                    pm.set(this.component, Panel.ON_CLOSE, null);
                    pm.close(this.component);
                }
                this.component = component;
                String title = component.getName();
                if (title == null) {
                    title = this.getValue("Name").toString();
                }
                HashMap<Object, Object> par = new HashMap<Object, Object>();
                if (OptionalPageHandler.this.state != null && (d = (DataPanelDescriptor)OptionalPageHandler.this.state.get(this.path)) != null && (data = d.getData()) != null) {
                    par.putAll(data);
                }
                par.put(Panel.TITLE, title);
                Consumer<JComponent> onClose = c -> this.close();
                par.put(Panel.ON_CLOSE, onClose);
                Console.getConsole().getPanelManager().open((Component)component, par);
            }
            OptionalPageHandler.this.descriptor.opened(this.path);
        }

        void close() {
            this.putValue("SwingSelectedKey", false);
            OptionalPageHandler.this.descriptor.closed(this.path);
            if (this.agents.isEmpty()) {
                this.uninstall();
            }
        }

        private String[] getMenuPath() {
            return this.path.substring(0, this.path.lastIndexOf("/")).split("/");
        }
    }
}

