/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer.filters;

import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;

public class DataDictionary
implements MessageFilter {
    @Override
    public String getPath() {
        return "BuiltIn/DataDictionary";
    }

    @Override
    public String getDescription() {
        return "Selects data dictionary publications and provides detailed views of them.";
    }

    @Override
    public FilteredMessage test(FilteredMessage filteredMessage) {
        BusMessage bm = filteredMessage.getBusMessage();
        boolean accept = bm instanceof StatusDataProviderDictionary;
        if (accept) {
            DataProviderDictionary dict = ((StatusDataProviderDictionary)bm).getDataProviderDictionary();
            StringBuilder sb = new StringBuilder("Data dictionary from " + bm.getOriginAgentInfo().getName()).append(System.lineSeparator());
            for (DataProviderInfo d : dict.getDataProviderInfos()) {
                sb.append(d.getPath()).append(System.lineSeparator());
            }
            sb.append(System.lineSeparator());
            filteredMessage.setText(sb.toString());
        }
        return accept ? filteredMessage : null;
    }
}

