/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida;

import hep.aida.ICloud;
import hep.aida.IDataPointSet;
import hep.aida.IFunction;
import hep.aida.IHistogram;
import hep.aida.IManagedObject;
import hep.aida.IProfile;
import hep.aida.ITree;
import hep.aida.ref.plotter.adapter.AIDAAdapter;
import jas.hist.DataSource;
import jas.hist.HasDataSource;
import java.util.StringTokenizer;
import org.freehep.application.studio.Studio;

public class AIDATreeDataSourceProvider
implements HasDataSource {
    private ITree aidaMasterTree;

    public DataSource getDataSource(String path) throws IllegalArgumentException {
        IManagedObject obj = this.getAIDAObject(path);
        DataSource data = null;
        if (obj instanceof DataSource) {
            data = (DataSource)obj;
        } else if (obj instanceof IProfile) {
            data = AIDAAdapter.create((IProfile)((IProfile)obj));
        } else if (obj instanceof ICloud) {
            data = AIDAAdapter.create((ICloud)((ICloud)obj));
        } else if (obj instanceof IHistogram) {
            data = AIDAAdapter.create((IHistogram)((IHistogram)obj));
        } else if (obj instanceof IDataPointSet) {
            data = AIDAAdapter.create((IDataPointSet)((IDataPointSet)obj));
        } else if (obj instanceof IFunction) {
            data = AIDAAdapter.create((IFunction)((IFunction)obj));
        } else {
            throw new IllegalArgumentException("Invalid object " + obj.getClass().getName() + ", for Path=" + path);
        }
        return data;
    }

    public IManagedObject getAIDAObject(String path) throws IllegalArgumentException {
        if (this.aidaMasterTree == null) {
            Studio app = (Studio)Studio.getApplication();
            this.aidaMasterTree = (ITree)app.getLookup().lookup(ITree.class);
        }
        IManagedObject obj = null;
        try {
            obj = this.aidaMasterTree.find(path);
        }
        catch (IllegalArgumentException iae) {
            String newPath = "/";
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            block4: while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                while (token.endsWith("\\")) {
                    token = token.substring(0, token.length() - 1) + "/";
                    if (!tokenizer.hasMoreTokens()) continue;
                    token = token + tokenizer.nextToken();
                }
                String[] names = this.aidaMasterTree.listObjectNames(newPath);
                String tmpPath = newPath + token;
                if (tokenizer.hasMoreTokens()) {
                    tmpPath = tmpPath + "/";
                }
                if (names == null) continue;
                for (int i = 0; i < names.length; ++i) {
                    if (!names[i].equalsIgnoreCase(tmpPath)) continue;
                    newPath = names[i];
                    continue block4;
                }
            }
            try {
                obj = this.aidaMasterTree.find(newPath);
            }
            catch (IllegalArgumentException iae2) {
                throw iae;
            }
        }
        return obj;
    }
}

