/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida;

import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IFunction;
import hep.aida.IManagedObject;
import hep.aida.IPlottable;
import hep.aida.IPlotter;
import hep.aida.IPlotterStyle;
import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.ConnectEvent;
import hep.aida.ref.event.Connectable;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.plotter.PlotterRegion;
import jas.hist.DataSource;
import jas.hist.JASHist;
import java.awt.Color;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.freehep.jas.extension.aida.AIDAPlot;
import org.freehep.jas.plugin.plotter.DefaultPlotter;
import org.freehep.jas.plugin.plotter.JAS3Plot;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;

class AIDARegion
extends PlotterRegion
implements AIDAListener {
    private PlotRegion region;
    private PlotFactory factory;
    private Plotter plot;
    private Vector sources;
    private JPanel noConnectionPanel;

    AIDARegion(PlotFactory factory, PlotRegion region) {
        this(factory, region, null);
    }

    AIDARegion(PlotFactory factory, PlotRegion region, IPlotter plotter) {
        super(plotter);
        this.factory = factory;
        this.region = region;
        this.sources = new Vector();
        this.noConnectionPanel = new JPanel();
    }

    public void addToRegion(Object thing, IPlotterStyle styleObj, String options) {
        if (this.plot == null || this.getPlot() == null) {
            Class<?> clazz = thing.getClass();
            if (IBaseHistogram.class.isAssignableFrom(clazz) || IDataPointSet.class.isAssignableFrom(clazz) || IFunction.class.isAssignableFrom(clazz)) {
                this.createPlot();
            } else {
                this.createPlot(thing);
            }
        }
        this.plot.plot(thing, this.getMode(options), (Object)styleObj, options);
        this.setConnection(thing);
    }

    void setAidaPlotter(Plotter plot) {
        this.plot = plot;
        this.setPlot((JASHist)((DefaultPlotter)plot).getPlot());
    }

    void createPlot() {
        if (this.plot == null) {
            this.plot = this.factory.createPlotterFor(IBaseHistogram.class);
            this.setAidaPlotter(this.plot);
            ((AIDAPlot)this.plot).setPlotterRegion(this);
            this.region.showPlot(this.plot);
        }
    }

    void createPlot(Object thing) {
        Class<?> clazz = null;
        if (thing instanceof IPlottable) {
            clazz = this.getClassForPlottable((IPlottable)thing);
        }
        if (clazz == null) {
            clazz = thing.getClass();
        }
        if (this.plot == null) {
            this.plot = this.factory.createPlotterFor(clazz);
            this.region.showPlot(this.plot);
        }
    }

    public void removeObjectFromRegion(Object thing) {
        super.removeObjectFromRegion(thing);
        this.clearObservable(thing);
    }

    public void removeDataSourceFromRegion(DataSource ds) {
        ((JAS3Plot)this.getPlot()).removeJAS3Data(ds);
    }

    public void clearRegion() {
        super.clearRegion();
        this.region.clear();
        this.plot = null;
        this.clearObservables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearObservable(Object thing) {
        if (this.sources.size() > 0) {
            Vector vector = this.sources;
            synchronized (vector) {
                boolean b = this.sources.remove(thing);
                if (thing instanceof IsObservable) {
                    ((IsObservable)thing).removeListener((AIDAListener)this);
                    this.connectAction((IsObservable)thing);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearObservables() {
        if (this.sources.size() > 0) {
            Vector vector = this.sources;
            synchronized (vector) {
                for (int i = 0; i < this.sources.size(); ++i) {
                    IsObservable o = (IsObservable)this.sources.get(i);
                    if (o == null) continue;
                    o.removeListener((AIDAListener)this);
                }
                this.sources.clear();
            }
            this.connectAction(null);
        }
    }

    private Class getClassForPlottable(IPlottable thing) {
        Class<?> clazz = null;
        String type = thing.type();
        try {
            clazz = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnection(Object thing) {
        if (thing instanceof IsObservable) {
            IsObservable observable = (IsObservable)thing;
            if (!this.sources.contains(observable)) {
                observable.addListener((AIDAListener)this);
                this.sources.add(observable);
                observable.setValid((AIDAListener)this);
            }
            IsObservable isObservable = observable;
            synchronized (isObservable) {
                this.connectAction(observable);
            }
        }
    }

    private boolean checkConnection() {
        boolean connection = true;
        Object[] array = this.sources.toArray();
        if (array == null || array.length == 0) {
            return connection;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] instanceof Connectable) || ((Connectable)array[i]).isConnected()) continue;
            connection = false;
            break;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(EventObject e) {
        if (!(e instanceof ConnectEvent)) {
            return;
        }
        ConnectEvent event = (ConnectEvent)e;
        Object obj = event.getSource();
        boolean connect = event.isConnected();
        IsObservable observable = null;
        String name = null;
        if (obj instanceof IManagedObject) {
            name = ((IManagedObject)obj).name();
        }
        if (!(obj instanceof IsObservable)) {
            throw new RuntimeException("Wrong Data Type: " + obj);
        }
        observable = (IsObservable)obj;
        Object object = obj;
        synchronized (object) {
            this.connectAction(observable);
        }
    }

    void connectAction(IsObservable obj) {
        boolean connect = this.checkConnection();
        AIDARegion.invokeOnSwingThread(new ConnectThread(obj, connect, this.noConnectionPanel, this));
    }

    private static void invokeOnSwingThread(Runnable run) {
        SwingUtilities.invokeLater(run);
    }

    class ConnectThread
    implements Runnable {
        IsObservable observable;
        boolean connect;
        AIDAListener listener;
        JComponent component;

        ConnectThread(IsObservable observable, boolean connect, JComponent component, AIDAListener listener) {
            this.observable = observable;
            this.connect = connect;
            this.listener = listener;
            this.component = component;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                try {
                    if (this.observable != null) {
                        IsObservable isObservable = this.observable;
                        synchronized (isObservable) {
                            if (this.connect) {
                                if (AIDARegion.this.plot != null && AIDARegion.this.plot.viewable() != null) {
                                    ((JComponent)AIDARegion.this.plot.viewable()).setBackground(Color.white);
                                }
                            } else {
                                ((JComponent)AIDARegion.this.plot.viewable()).setBackground(Color.red);
                            }
                            this.observable.setValid(this.listener);
                            break block12;
                        }
                    }
                    if (AIDARegion.this.plot != null && AIDARegion.this.plot.viewable() != null) {
                        if (this.connect) {
                            ((JComponent)AIDARegion.this.plot.viewable()).setBackground(Color.white);
                        } else {
                            ((JComponent)AIDARegion.this.plot.viewable()).setBackground(Color.red);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

