/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida;

import hep.aida.ICloud;
import hep.aida.IDataPointSet;
import hep.aida.IFunction;
import hep.aida.IHistogram;
import hep.aida.IManagedObject;
import hep.aida.IProfile;
import hep.aida.ref.plotter.adapter.AIDAAdapter;
import hep.aida.ref.plotter.adapter.AIDACloudAdapter1D;
import hep.aida.ref.plotter.adapter.AIDADataPointSetAdapter;
import hep.aida.ref.plotter.adapter.AIDAHistogramAdapter1D;
import hep.aida.ref.plotter.adapter.AIDAProfileAdapter1D;
import jas.hist.DataSource;
import java.awt.Component;
import javax.swing.JPopupMenu;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extension.aida.AIDAPlugin;
import org.freehep.jas.plugin.plotter.JAS3DataSource;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.services.PlotterAdapter;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.xml.io.XMLIO;
import org.freehep.xml.io.XMLIOFactory;
import org.freehep.xml.io.XMLIOManager;
import org.jdom.Element;

public class AIDAPlotAdapter
implements PlotterAdapter<JAS3DataSource, Object> {
    private AIDAPlugin thePlugin;
    private static boolean factoryRegistered = false;

    protected AIDAPlotAdapter(AIDAPlugin thePlugin, Studio app) {
        this.thePlugin = thePlugin;
        if (!factoryRegistered) {
            factoryRegistered = true;
            app.getLookup().add((Object)new JAS3DataSourceConverterFactory(thePlugin));
        }
    }

    public JAS3DataSource adapt(Object obj) {
        return new JAS3DataSourceConverter(this.thePlugin, obj);
    }

    private class JAS3DataSourceConverterFactory
    implements XMLIOFactory {
        private AIDAPlugin thePlugin;
        private Class[] classes = new Class[]{JAS3DataSourceConverter.class};

        JAS3DataSourceConverterFactory(AIDAPlugin thePlugin) {
            this.thePlugin = thePlugin;
        }

        public Class[] XMLIOFactoryClasses() {
            return this.classes;
        }

        public Object createObject(Class objClass) throws IllegalArgumentException {
            if (objClass == JAS3DataSourceConverter.class) {
                return new JAS3DataSourceConverter(this.thePlugin, null);
            }
            throw new IllegalArgumentException("Cannot create class " + objClass);
        }
    }

    protected class JAS3DataSourceConverter
    implements JAS3DataSource,
    XMLIO {
        private DataSource data;
        private Object obj;
        private AIDAPlugin thePlugin;

        JAS3DataSourceConverter(AIDAPlugin thePlugin, Object obj) {
            this.setObject(obj);
            this.thePlugin = thePlugin;
        }

        protected void loadDataSource(Object obj) {
            if (obj instanceof DataSource) {
                this.data = (DataSource)obj;
            } else if (obj instanceof IProfile) {
                this.data = AIDAAdapter.create((IProfile)((IProfile)obj));
            } else if (obj instanceof ICloud) {
                this.data = AIDAAdapter.create((ICloud)((ICloud)obj));
            } else if (obj instanceof IHistogram) {
                this.data = AIDAAdapter.create((IHistogram)((IHistogram)obj));
            } else if (obj instanceof IDataPointSet) {
                this.data = AIDAAdapter.create((IDataPointSet)((IDataPointSet)obj));
            } else if (obj instanceof IFunction) {
                this.data = AIDAAdapter.create((IFunction)((IFunction)obj));
            } else {
                throw new IllegalArgumentException("Invalid object " + obj.getClass());
            }
        }

        protected Object object() {
            return this.obj;
        }

        protected void setObject(Object obj) {
            if (obj != null) {
                this.obj = obj;
                this.loadDataSource(obj);
            }
        }

        public DataSource dataSource() {
            return this.data;
        }

        public void destroy() {
        }

        public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
            try {
                HasPopupItems plottedObject = (HasPopupItems)this.obj;
                plottedObject.modifyPopupMenu(jPopupMenu, component, null);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void restore(XMLIOManager xmlioManager, Element nodeEl) {
            String path = nodeEl.getAttributeValue("path");
            if (path != null) {
                this.setObject(this.thePlugin.aidaMasterTree().find(path));
            }
        }

        public void save(XMLIOManager xmlioManager, Element nodeEl) {
            try {
                if (this.obj instanceof IManagedObject) {
                    String path = this.thePlugin.aidaMasterTree().findPath((IManagedObject)this.obj);
                    nodeEl.setAttribute("path", path);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public FTreePath path() {
            if (this.obj instanceof IManagedObject) {
                return this.thePlugin.pathForManagedObject((IManagedObject)this.object());
            }
            return new FTreePath("");
        }

        public String[] axisLabels() {
            return null;
        }

        public void setAxisType(int type) {
            if (this.data instanceof AIDADataPointSetAdapter) {
                ((AIDADataPointSetAdapter)this.data).setAxisType(type);
            } else if (this.data instanceof AIDAHistogramAdapter1D) {
                ((AIDAHistogramAdapter1D)this.data).setAxisType(type);
            } else if (this.data instanceof AIDACloudAdapter1D) {
                ((AIDACloudAdapter1D)this.data).setAxisType(type);
            } else if (this.data instanceof AIDAProfileAdapter1D) {
                ((AIDAProfileAdapter1D)this.data).setAxisType(type);
            }
        }
    }
}

