/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.treetable;

import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import org.freehep.swing.treetable.TreeTableModel;

public class TreeTableModelAdapter
extends AbstractTableModel {
    JTree tree;
    TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.treeTableModel.isCellEditable(this.pathForRow(row), column);
    }

    public Class getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.treeTableModel.setValueAt(value, this.pathForRow(row), column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.treeTableModel.getValueAt(this.pathForRow(row), column);
    }

    protected int getRowForLocation(int x, int y) {
        return this.tree.getRowForLocation(x, y);
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        if (treePath == null) {
            System.err.println("WARNING: nodeForRow returning null for " + row);
            return null;
        }
        return treePath.getLastPathComponent();
    }

    protected TreePath pathForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        if (treePath == null) {
            System.err.println("WARNING: pathForRow returning null for " + row);
            return null;
        }
        return treePath;
    }
}

